/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.modified.StructureModificationChecker;
import org.jboss.profileservice.spi.AttachmentsSerializer;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.system.server.profileservice.repository.SerializableDeploymentRepository;
import org.jboss.virtual.VirtualFileFilter;

public class SerializableDeploymentRepositoryFactory
implements DeploymentRepositoryFactory {
    private File root;
    private String attachmentsRoot;
    private URI[] appURIs = new URI[0];
    private AttachmentsSerializer serializer;
    private MainDeployerStructure mainDeployer;
    private VirtualFileFilter deploymentFilter;
    private VirtualFileFilter hotDeploymentFilter;
    private StructureModificationChecker checker;
    private Map<ProfileKey, DeploymentRepository> profileRepositories = new HashMap<ProfileKey, DeploymentRepository>();

    public File getStoreRoot() {
        return this.root;
    }

    public void setStoreRoot(File root) {
        this.root = root;
    }

    public String getAttachmentsRoot() {
        return this.attachmentsRoot;
    }

    public void setAttachmentsRoot(String attachmentsRoot) {
        this.attachmentsRoot = attachmentsRoot;
    }

    public URI[] getApplicationURIs() {
        return this.appURIs;
    }

    public void setApplicationURIs(URI[] appURIs) {
        this.appURIs = appURIs;
    }

    public AttachmentsSerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(AttachmentsSerializer serializer) {
        this.serializer = serializer;
    }

    public VirtualFileFilter getDeploymentFilter() {
        return this.deploymentFilter;
    }

    public void setDeploymentFilter(VirtualFileFilter deploymentFilter) {
        this.deploymentFilter = deploymentFilter;
    }

    @Deprecated
    public VirtualFileFilter getHotDeploymentFilter() {
        return this.hotDeploymentFilter;
    }

    @Deprecated
    public void setHotDeploymentFilter(VirtualFileFilter hotDeploymentFilter) {
        this.hotDeploymentFilter = hotDeploymentFilter;
    }

    public MainDeployerStructure getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerStructure mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public StructureModificationChecker getChecker() {
        return this.checker;
    }

    public void setChecker(StructureModificationChecker checker) {
        this.checker = checker;
    }

    public synchronized DeploymentRepository getDeploymentRepository(ProfileKey key) {
        DeploymentRepository dr;
        if (this.appURIs == null || this.appURIs.length == 0) {
            File deployDir = new File(this.root, key.getName() + "/deploy");
            this.appURIs = new URI[]{deployDir.toURI()};
        }
        if ((dr = this.profileRepositories.get(key)) == null) {
            SerializableDeploymentRepository repo = new SerializableDeploymentRepository(this.root, this.appURIs, key);
            repo.setAttachmentsRoot(this.attachmentsRoot);
            repo.setSerializer(this.serializer);
            repo.setDeploymentFilter(this.deploymentFilter);
            repo.setHotDeploymentFilter(this.hotDeploymentFilter);
            repo.setMainDeployer(this.mainDeployer);
            repo.setChecker(this.checker);
            this.profileRepositories.put(key, repo);
            dr = repo;
        }
        return dr;
    }
}

