/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.attachments;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.system.server.profileservice.attachments.AttachmentMetaData;
import org.jboss.system.server.profileservice.attachments.DeploymentClassPathMetaData;
import org.jboss.system.server.profileservice.attachments.DeploymentStructureMetaData;
import org.jboss.system.server.profileservice.attachments.RepositoryAttachmentMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryAttachmentMetaDataFactory {
    public static RepositoryAttachmentMetaData createInstance() {
        return new RepositoryAttachmentMetaData();
    }

    public static RepositoryAttachmentMetaData createInstance(ManagedDeployment md) {
        if (md == null) {
            throw new IllegalArgumentException("managed deployment may not be null.");
        }
        RepositoryAttachmentMetaData metaData = RepositoryAttachmentMetaDataFactory.createInstance();
        metaData.setDeploymentName(md.getSimpleName());
        return metaData;
    }

    public static RepositoryAttachmentMetaData createNewParent(ManagedDeployment md, RepositoryAttachmentMetaData child) {
        if (md == null) {
            throw new IllegalArgumentException("managed deployment may not be null.");
        }
        RepositoryAttachmentMetaData metaData = RepositoryAttachmentMetaDataFactory.createInstance(md);
        RepositoryAttachmentMetaDataFactory.addChild(metaData, child);
        return metaData;
    }

    public static void addChild(RepositoryAttachmentMetaData parent, RepositoryAttachmentMetaData child) {
        if (parent == null) {
            throw new IllegalArgumentException("parent may not be null.");
        }
        if (parent.getChildren() == null) {
            parent.setChildren(new ArrayList<RepositoryAttachmentMetaData>());
        }
        parent.getChildren().add(child);
    }

    public static void addAttachment(RepositoryAttachmentMetaData metaData, AttachmentMetaData attachment) {
        if (metaData == null) {
            throw new IllegalArgumentException("meta data may not be null.");
        }
        if (metaData.getAttachments() == null) {
            metaData.setAttachments(new ArrayList<AttachmentMetaData>());
        }
        metaData.getAttachments().add(attachment);
    }

    public static void applyStructureContext(RepositoryAttachmentMetaData metaData, ContextInfo info) {
        if (metaData == null) {
            throw new IllegalArgumentException("meta data may not be null.");
        }
        if (info == null) {
            throw new IllegalArgumentException("context info may not be null.");
        }
        DeploymentStructureMetaData structure = new DeploymentStructureMetaData();
        structure.setMetaDataPaths(info.getMetaDataPath());
        structure.setClassPaths(RepositoryAttachmentMetaDataFactory.getDeploymentClassPathMetaData(info));
        structure.setComparatorClass(info.getComparatorClassName());
        structure.setRelatativeOrder(info.getRelativeOrder());
        metaData.setDeploymentStructure(structure);
    }

    public static AttachmentMetaData findAttachment(String name, List<AttachmentMetaData> attachments) {
        if (name == null) {
            return null;
        }
        if (attachments == null) {
            return null;
        }
        for (AttachmentMetaData attachment : attachments) {
            if (!name.equals(attachment.getName())) continue;
            return attachment;
        }
        return null;
    }

    protected static List<DeploymentClassPathMetaData> getDeploymentClassPathMetaData(ContextInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("context info may not be null.");
        }
        if (info.getClassPath() == null || info.getClassPath().isEmpty()) {
            return null;
        }
        ArrayList<DeploymentClassPathMetaData> classPath = new ArrayList<DeploymentClassPathMetaData>();
        for (ClassPathEntry entry : info.getClassPath()) {
            classPath.add(new DeploymentClassPathMetaData(entry.getPath(), entry.getSuffixes()));
        }
        return classPath;
    }
}

