/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.util.ArrayList;
import java.util.List;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileFactory;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileKeyMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProfileFactory
implements ProfileFactory {
    public abstract Profile createProfile(ProfileKey var1, ProfileMetaData var2, List<ProfileKey> var3) throws Exception;

    public Profile createProfile(ProfileKey key, ProfileMetaData metaData) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Null profile key.");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null profile meta data.");
        }
        return this.createProfile(key, metaData, this.createSubProfiles(metaData));
    }

    protected List<ProfileKey> createSubProfiles(ProfileMetaData metaData) {
        ArrayList<ProfileKey> subProfiles = new ArrayList<ProfileKey>();
        if (metaData.getSubprofiles() != null && !metaData.getSubprofiles().isEmpty()) {
            for (SubProfileMetaData subProfile : metaData.getSubprofiles()) {
                subProfiles.add(this.createKey((ProfileKeyMetaData)subProfile));
            }
        }
        return subProfiles;
    }

    protected ProfileKey createKey(ProfileKeyMetaData metaData) {
        return new ProfileKey(metaData.getDomain(), metaData.getServer(), metaData.getName());
    }
}

