/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class FormAuthValve
extends ValveBase {
    private static Logger log = Logger.getLogger(FormAuthValve.class);
    private static boolean trace = log.isTraceEnabled();
    private boolean includePassword;

    public boolean isIncludePassword() {
        return this.includePassword;
    }

    public void setIncludePassword(boolean includePassword) {
        this.includePassword = includePassword;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String username = request.getParameter("j_username");
        HttpSession session = request.getSession(false);
        if (trace) {
            log.trace((Object)("Enter, j_username=" + username));
        }
        if (session != null) {
            String pass;
            if (username != null) {
                session.setAttribute("j_username", (Object)username);
            }
            if (this.includePassword && (pass = request.getParameter("j_password")) != null) {
                session.setAttribute("j_password", (Object)pass);
            }
        }
        this.getNext().invoke(request, response);
        username = request.getParameter("j_username");
        session = request.getSession(false);
        if (session != null) {
            if (trace) {
                log.trace((Object)("SessionID: " + session.getId()));
            }
            if (username != null) {
                session.setAttribute("j_username", (Object)username);
            }
            Throwable t = SecurityAssociationActions.getAuthException();
            if (trace) {
                log.trace((Object)("SecurityAssociation.exception: " + t));
            }
            if (t != null) {
                session.setAttribute("j_exception", (Object)t);
            }
        }
        if (trace) {
            log.trace((Object)("Exit, username: " + username));
        }
    }
}

