/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.util.ArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class ClusteringDependencyDeployer
extends AbstractDeployer {
    private String clusterCacheDependency;

    public ClusteringDependencyDeployer() {
        this.setStage(DeploymentStages.DESCRIBE);
        this.setInput(JBossWebMetaData.class);
        this.setOutput(JBossWebMetaData.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (metaData != null && metaData.getDistributable() != null) {
            if (this.clusterCacheDependency != null) {
                this.log.debug((Object)("Adding dependency on " + this.clusterCacheDependency + " to " + unit.getName()));
                ArrayList<String> depends = metaData.getDepends();
                if (depends == null) {
                    depends = new ArrayList<String>();
                }
                if (!depends.contains(this.clusterCacheDependency)) {
                    depends.add(this.clusterCacheDependency);
                }
                metaData.setDepends(depends);
            } else {
                this.log.warn((Object)"clusterCacheDependency is null; either configure it or remove this deployer");
            }
        }
    }

    public String getClusterCacheDependency() {
        return this.clusterCacheDependency;
    }

    public void setClusterCacheDependency(String clusterDependency) {
        this.clusterCacheDependency = clusterDependency;
    }
}

