/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import javax.xml.namespace.QName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Store;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.JspPropertyGroup;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.Multipart;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.SessionCookie;
import org.apache.catalina.deploy.jsp.FunctionInfo;
import org.apache.catalina.deploy.jsp.TagAttributeInfo;
import org.apache.catalina.deploy.jsp.TagFileInfo;
import org.apache.catalina.deploy.jsp.TagInfo;
import org.apache.catalina.deploy.jsp.TagLibraryInfo;
import org.apache.catalina.deploy.jsp.TagLibraryValidatorInfo;
import org.apache.catalina.deploy.jsp.TagVariableInfo;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.ContextConfig;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.tomcat.util.IntrospectionUtils;
import org.jboss.annotation.javaee.Icon;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationMetaData;
import org.jboss.metadata.web.jboss.JBossAnnotationsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AttributeMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.FunctionMetaData;
import org.jboss.metadata.web.spec.HttpMethodConstraintMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroupMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingsMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.MultipartConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletSecurityMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.SessionTrackingModeType;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TagMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.TldMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.VariableMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.metadata.web.spec.WelcomeFileListMetaData;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.vfs.VirtualFile;
import org.jboss.web.deployers.MergedJBossWebMetaDataDeployer;
import org.jboss.web.deployers.ServletContainerInitializerDeployer;
import org.jboss.web.deployers.SharedJBossWebMetaDataDeployer;
import org.jboss.web.tomcat.metadata.ContextMetaData;
import org.jboss.web.tomcat.metadata.ManagerMetaData;
import org.jboss.web.tomcat.metadata.ParameterMetaData;
import org.jboss.web.tomcat.service.deployers.DeployerConfig;
import org.jboss.web.tomcat.service.deployers.SecurityActions;
import org.jboss.web.tomcat.service.deployers.TomcatService;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.builder.JBossXBBuilder;
import org.xml.sax.EntityResolver;

public class JBossContextConfig
extends ContextConfig {
    public static ThreadLocal<JBossWebMetaData> metaDataLocal = new ThreadLocal();
    public static ThreadLocal<Map<String, TldMetaData>> tldMetaDataMapLocal = new ThreadLocal();
    public static ThreadLocal<Kernel> kernelLocal = new ThreadLocal();
    public static ThreadLocal<DeploymentUnit> deploymentUnitLocal = new ThreadLocal();
    public static ThreadLocal<DeployerConfig> deployerConfig = new ThreadLocal();
    private static Logger log = Logger.getLogger(JBossContextConfig.class);
    private Set<String> overlays = new HashSet<String>();
    private boolean runDestroy = false;

    public JBossContextConfig() {
        try {
            Map authMap = this.getAuthenticators();
            if (authMap.size() > 0) {
                this.customAuthenticators = authMap;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to load the customized authenticators", (Throwable)e);
        }
        this.runDestroy = deployerConfig.get().isDeleteWorkDirs();
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("after_start")) {
            Set scis = (Set)deploymentUnitLocal.get().getAttachment(ServletContainerInitializerDeployer.SCI_ATTACHMENT_NAME);
            Map handlesTypes = (Map)deploymentUnitLocal.get().getAttachment(ServletContainerInitializerDeployer.SCI_HANDLESTYPES_ATTACHMENT_NAME);
            if (scis != null) {
                for (ServletContainerInitializer sci : scis) {
                    try {
                        sci.onStartup((Set)handlesTypes.get(sci), this.context.getServletContext());
                    }
                    catch (Throwable t) {
                        log.error((Object)("Error calling onStartup for servlet container initializer: " + sci.getClass().getName()), t);
                        this.ok = false;
                    }
                }
            }
            List order = (List)deploymentUnitLocal.get().getAttachment(MergedJBossWebMetaDataDeployer.WEB_ORDER_ATTACHMENT_NAME);
            if (deploymentUnitLocal.get().getAttachment(MergedJBossWebMetaDataDeployer.WEB_NOORDER_ATTACHMENT_NAME) != Boolean.TRUE) {
                this.context.getServletContext().setAttribute("javax.servlet.context.orderedLibs", (Object)order);
            }
        }
        super.lifecycleEvent(event);
    }

    protected void applicationWebConfig() {
        this.processWebMetaData(metaDataLocal.get());
        this.processContextParameters();
    }

    protected void defaultWebConfig() {
        JBossWebMetaData sharedJBossWebMetaData = (JBossWebMetaData)deploymentUnitLocal.get().getAttachment(SharedJBossWebMetaDataDeployer.SHARED_JBOSSWEB_ATTACHMENT_NAME);
        if (sharedJBossWebMetaData != null) {
            this.processWebMetaData(sharedJBossWebMetaData);
        }
        ServletContext servletContext = this.context.getServletContext();
        Kernel kernel = kernelLocal.get();
        DeploymentUnit unit = deploymentUnitLocal.get();
        log.debug((Object)("Setting MC attributes, kernel: " + kernel + ", unit: " + unit));
        servletContext.setAttribute("jboss.kernel:service=Kernel", (Object)kernel);
        servletContext.setAttribute(DeploymentUnit.class.getName(), (Object)unit);
    }

    protected void processWebMetaData(JBossWebMetaData metaData) {
        SessionConfigMetaData scmd;
        WelcomeFileListMetaData welcomeFiles;
        LocaleEncodingsMetaData locales;
        JspConfigMetaData config;
        List smappings;
        JBossServletsMetaData servlets;
        SecurityRolesMetaData roles;
        List scs;
        List mimes;
        LoginConfigMetaData loginConfig;
        List listeners;
        List filtersMappings;
        FiltersMetaData filters;
        List errorPages;
        String displayName;
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
        }
        this.context.setVersion(metaData.getVersion());
        if (metaData.is30()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_3_0.dtd");
        } else if (metaData.is25()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_5.dtd");
        } else if (metaData.is24()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_4.dtd");
        } else if (metaData.is23()) {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        } else {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
        }
        DescriptionGroupMetaData dg = metaData.getDescriptionGroup();
        if (dg != null && (displayName = dg.getDisplayName()) != null) {
            this.context.setDisplayName(displayName);
        }
        if (metaData.getDistributable() != null) {
            this.context.setDistributable(true);
        }
        if ((errorPages = metaData.getErrorPages()) != null) {
            for (ErrorPageMetaData value : errorPages) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(value.getErrorCode());
                errorPage.setExceptionType(value.getExceptionType());
                errorPage.setLocation(value.getLocation());
                this.context.addErrorPage(errorPage);
            }
        }
        if ((filters = metaData.getFilters()) != null) {
            for (FilterMetaData value : filters) {
                FilterDef filterDef = new FilterDef();
                filterDef.setFilterName(value.getName());
                filterDef.setFilterClass(value.getFilterClass());
                if (value.getInitParam() != null) {
                    for (ParamValueMetaData param : value.getInitParam()) {
                        filterDef.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                filterDef.setAsyncSupported(value.isAsyncSupported());
                this.context.addFilterDef(filterDef);
            }
        }
        if ((filtersMappings = metaData.getFilterMappings()) != null) {
            for (FilterMappingMetaData value : filtersMappings) {
                List dispatchers;
                List urlPatterns;
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(value.getFilterName());
                List servletNames = value.getServletNames();
                if (servletNames != null) {
                    for (String name : servletNames) {
                        filterMap.addServletName(name);
                    }
                }
                if ((urlPatterns = value.getUrlPatterns()) != null) {
                    for (String pattern : urlPatterns) {
                        filterMap.addURLPattern(pattern);
                    }
                }
                if ((dispatchers = value.getDispatchers()) != null) {
                    for (DispatcherType type : dispatchers) {
                        filterMap.setDispatcher(type.name());
                    }
                }
                this.context.addFilterMap(filterMap);
            }
        }
        if ((listeners = metaData.getListeners()) != null) {
            for (ListenerMetaData value : listeners) {
                this.context.addApplicationListener(value.getListenerClass());
            }
        }
        if ((loginConfig = metaData.getLoginConfig()) != null) {
            LoginConfig loginConfig2 = new LoginConfig();
            loginConfig2.setAuthMethod(loginConfig.getAuthMethod());
            loginConfig2.setRealmName(loginConfig.getRealmName());
            if (loginConfig.getFormLoginConfig() != null) {
                loginConfig2.setLoginPage(loginConfig.getFormLoginConfig().getLoginPage());
                loginConfig2.setErrorPage(loginConfig.getFormLoginConfig().getErrorPage());
            }
            this.context.setLoginConfig(loginConfig2);
        }
        if ((mimes = metaData.getMimeMappings()) != null) {
            for (MimeMappingMetaData value : mimes) {
                this.context.addMimeMapping(value.getExtension(), value.getMimeType());
            }
        }
        if ((scs = metaData.getSecurityConstraints()) != null) {
            for (SecurityConstraintMetaData value : scs) {
                WebResourceCollectionsMetaData wrcs;
                SecurityConstraint constraint = new SecurityConstraint();
                TransportGuaranteeType tg = value.getTransportGuarantee();
                constraint.setUserConstraint(tg.name());
                AuthConstraintMetaData acmd = value.getAuthConstraint();
                constraint.setAuthConstraint(acmd != null);
                if (acmd != null && acmd.getRoleNames() != null) {
                    for (String role : acmd.getRoleNames()) {
                        constraint.addAuthRole(role);
                    }
                }
                if ((wrcs = value.getResourceCollections()) != null) {
                    for (WebResourceCollectionMetaData wrc : wrcs) {
                        List patterns;
                        List methodOmissions;
                        SecurityCollection collection2 = new SecurityCollection();
                        collection2.setName(wrc.getName());
                        List methods = wrc.getHttpMethods();
                        if (methods != null) {
                            for (String method : wrc.getHttpMethods()) {
                                collection2.addMethod(method);
                            }
                        }
                        if ((methodOmissions = wrc.getHttpMethodOmissions()) != null) {
                            for (String method : wrc.getHttpMethodOmissions()) {
                                collection2.addMethodOmission(method);
                            }
                        }
                        if ((patterns = wrc.getUrlPatterns()) != null) {
                            for (String pattern : patterns) {
                                collection2.addPattern(pattern);
                            }
                        }
                        constraint.addCollection(collection2);
                    }
                }
                this.context.addConstraint(constraint);
            }
        }
        if ((roles = metaData.getSecurityRoles()) != null) {
            for (SecurityRoleMetaData value : roles) {
                this.context.addSecurityRole(value.getRoleName());
            }
        }
        if ((servlets = metaData.getServlets()) != null) {
            for (JBossServletMetaData value : servlets) {
                SecurityRoleRefsMetaData refs;
                List params;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(value.getName());
                wrapper.setServletClass(value.getServletClass());
                if (value.getJspFile() != null) {
                    wrapper.setJspFile(value.getJspFile());
                }
                wrapper.setLoadOnStartup(value.getLoadOnStartupInt());
                if (value.getRunAs() != null) {
                    wrapper.setRunAs(value.getRunAs().getRoleName());
                }
                if ((params = value.getInitParam()) != null) {
                    for (ParamValueMetaData param : params) {
                        wrapper.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                if ((refs = value.getSecurityRoleRefs()) != null) {
                    for (SecurityRoleRefMetaData ref : refs) {
                        wrapper.addSecurityReference(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                wrapper.setAsyncSupported(value.isAsyncSupported());
                wrapper.setEnabled(value.isEnabled());
                if (value.getMultipartConfig() != null) {
                    MultipartConfigMetaData multipartConfigMetaData = value.getMultipartConfig();
                    Multipart multipartConfig = new Multipart();
                    multipartConfig.setLocation(multipartConfigMetaData.getLocation());
                    multipartConfig.setMaxRequestSize(multipartConfigMetaData.getMaxRequestSize());
                    multipartConfig.setMaxFileSize(multipartConfigMetaData.getMaxFileSize());
                    multipartConfig.setFileSizeThreshold(multipartConfigMetaData.getFileSizeThreshold());
                    wrapper.setMultipartConfig(multipartConfig);
                }
                this.context.addChild((Container)wrapper);
            }
        }
        if ((smappings = metaData.getServletMappings()) != null) {
            for (ServletMappingMetaData value : smappings) {
                List urlPatterns = value.getUrlPatterns();
                if (urlPatterns == null) continue;
                for (String pattern : urlPatterns) {
                    this.context.addServletMapping(pattern, value.getServletName());
                }
            }
        }
        if ((config = metaData.getJspConfig()) != null) {
            List taglibs;
            List groups = config.getPropertyGroups();
            if (groups != null) {
                for (JspPropertyGroupMetaData group : groups) {
                    JspPropertyGroup jspPropertyGroup = new JspPropertyGroup();
                    for (String pattern : group.getUrlPatterns()) {
                        jspPropertyGroup.addUrlPattern(pattern);
                    }
                    jspPropertyGroup.setElIgnored(group.getElIgnored());
                    jspPropertyGroup.setPageEncoding(group.getPageEncoding());
                    jspPropertyGroup.setScriptingInvalid(group.getScriptingInvalid());
                    jspPropertyGroup.setIsXml(group.getIsXml());
                    if (group.getIncludePreludes() != null) {
                        for (String includePrelude : group.getIncludePreludes()) {
                            jspPropertyGroup.addIncludePrelude(includePrelude);
                        }
                    }
                    if (group.getIncludeCodas() != null) {
                        for (String includeCoda : group.getIncludeCodas()) {
                            jspPropertyGroup.addIncludeCoda(includeCoda);
                        }
                    }
                    jspPropertyGroup.setDeferredSyntaxAllowedAsLiteral(group.getDeferredSyntaxAllowedAsLiteral());
                    jspPropertyGroup.setTrimDirectiveWhitespaces(group.getTrimDirectiveWhitespaces());
                    jspPropertyGroup.setDefaultContentType(group.getDefaultContentType());
                    jspPropertyGroup.setBuffer(group.getBuffer());
                    jspPropertyGroup.setErrorOnUndeclaredNamespace(group.getErrorOnUndeclaredNamespace());
                    this.context.addJspPropertyGroup(jspPropertyGroup);
                }
            }
            if ((taglibs = config.getTaglibs()) != null) {
                for (TaglibMetaData taglib : taglibs) {
                    this.context.addTaglib(taglib.getTaglibUri(), taglib.getTaglibLocation());
                }
            }
        }
        if ((locales = metaData.getLocalEncodings()) != null) {
            for (LocaleEncodingMetaData value : locales.getMappings()) {
                this.context.addLocaleEncodingMappingParameter(value.getLocale(), value.getEncoding());
            }
        }
        if ((welcomeFiles = metaData.getWelcomeFileList()) != null) {
            for (String value : welcomeFiles.getWelcomeFiles()) {
                this.context.addWelcomeFile(value);
            }
        }
        if ((scmd = metaData.getSessionConfig()) != null) {
            this.context.setSessionTimeout(scmd.getSessionTimeout());
            if (scmd.getSessionTrackingModes() != null) {
                for (SessionTrackingModeType stmt : scmd.getSessionTrackingModes()) {
                    this.context.addSessionTrackingMode(stmt.toString());
                }
            }
            if (scmd.getCookieConfig() != null) {
                String value;
                value = scmd.getCookieConfig();
                SessionCookie cookieConfig = new SessionCookie();
                cookieConfig.setName(value.getName());
                cookieConfig.setDomain(value.getDomain());
                cookieConfig.setPath(value.getPath());
                cookieConfig.setComment(value.getComment());
                cookieConfig.setHttpOnly(value.getHttpOnly());
                cookieConfig.setSecure(value.getSecure());
                cookieConfig.setMaxAge(value.getMaxAge());
                this.context.setSessionCookie(cookieConfig);
            }
        }
    }

    protected Map getAuthenticators() throws Exception {
        HashMap authenticators = new HashMap();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Properties authProps = this.getAuthenticatorsFromJndi();
        if (authProps != null) {
            Iterator<Object> iter;
            Set<Object> keys = authProps.keySet();
            Iterator<Object> iterator = iter = keys != null ? keys.iterator() : null;
            while (iter != null && iter.hasNext()) {
                String key = (String)iter.next();
                String authenticatorStr = (String)authProps.get(key);
                Class<?> authClass = tcl.loadClass(authenticatorStr);
                authenticators.put(key, authClass.newInstance());
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Authenticators plugged in::" + authenticators));
        }
        return authenticators;
    }

    private Properties getAuthenticatorsFromJndi() throws NamingException {
        return (Properties)new InitialContext().lookup("TomcatAuthenticators");
    }

    protected void processContextParameters() {
        JBossWebMetaData local = metaDataLocal.get();
        JBossWebMetaData shared = (JBossWebMetaData)deploymentUnitLocal.get().getAttachment(SharedJBossWebMetaDataDeployer.SHARED_JBOSSWEB_ATTACHMENT_NAME);
        if (shared == null) {
            return;
        }
        HashMap<String, String> overrideParams = new HashMap<String, String>();
        List params = local.getContextParams();
        if (params != null) {
            for (ParamValueMetaData param : params) {
                overrideParams.put(param.getParamName(), param.getParamValue());
            }
        }
        if ((params = shared.getContextParams()) != null) {
            for (ParamValueMetaData param : params) {
                if (overrideParams.get(param.getParamName()) != null) continue;
                overrideParams.put(param.getParamName(), param.getParamValue());
            }
        }
        for (String key : overrideParams.keySet()) {
            this.context.addParameter(key, (String)overrideParams.get(key));
        }
    }

    protected void init() {
        this.context.setConfigured(false);
        this.ok = true;
        if (!this.context.getOverride()) {
            this.processContextConfig("context.xml", false);
            this.processContextConfig(this.getHostConfigPath("context.xml.default"), false);
        }
        this.processContextConfig("WEB-INF/context.xml", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(String resourceName, boolean local) {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        ContextMetaData contextMetaData = null;
        try {
            SchemaBinding schema = JBossXBBuilder.build(ContextMetaData.class);
            Unmarshaller u = UnmarshallerFactory.newInstance().newUnmarshaller();
            u.setSchemaValidation(false);
            u.setValidation(false);
            u.setEntityResolver((EntityResolver)new JBossEntityResolver());
            InputStream is = null;
            try {
                VFSDeploymentUnit vfsUnit;
                VirtualFile vf;
                DeploymentUnit localUnit;
                if (local && (localUnit = deploymentUnitLocal.get()) instanceof VFSDeploymentUnit && (vf = (vfsUnit = (VFSDeploymentUnit)localUnit).getFile(resourceName)) != null) {
                    is = vf.openStream();
                }
                if (is == null) {
                    is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName);
                }
                if (is != null) {
                    contextMetaData = (ContextMetaData)ContextMetaData.class.cast(u.unmarshal(is, schema));
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("XML error parsing: " + resourceName), (Throwable)e);
            this.ok = false;
            return;
        }
        finally {
            SecurityActions.setContextClassLoader(oldCl);
        }
        if (contextMetaData != null) {
            try {
                Iterator<String> listeners;
                if (contextMetaData.getAttributes() != null) {
                    for (QName name : contextMetaData.getAttributes().keySet()) {
                        String value = (String)contextMetaData.getAttributes().get(name);
                        value = StringPropertyReplacer.replaceProperties((String)value);
                        IntrospectionUtils.setProperty((Object)this.context, (String)name.getLocalPart(), (String)value);
                    }
                }
                TomcatService.addLifecycleListeners(this.context, contextMetaData.getListeners());
                if (contextMetaData.getRealm() != null) {
                    this.context.setRealm((Realm)TomcatService.getInstance(contextMetaData.getRealm(), null));
                }
                TomcatService.addValves(this.context, contextMetaData.getValves());
                if (contextMetaData.getInstanceListeners() != null) {
                    listeners = contextMetaData.getInstanceListeners().iterator();
                    while (listeners.hasNext()) {
                        this.context.addInstanceListener(listeners.next());
                    }
                }
                if (contextMetaData.getLoader() != null) {
                    this.context.setLoader((Loader)TomcatService.getInstance(contextMetaData.getLoader(), "org.apache.catalina.loader.WebappLoader"));
                }
                if (contextMetaData.getManager() != null) {
                    Manager manager = this.initManager(contextMetaData.getManager());
                    if (contextMetaData.getManager().getStore() != null) {
                        Store store = (Store)TomcatService.getInstance(contextMetaData.getManager().getStore(), null);
                        try {
                            PersistentManagerBase.class.getMethod("setStore", Store.class).invoke((Object)manager, store);
                        }
                        catch (Throwable t) {
                            log.error((Object)"Could not set persistent store", t);
                        }
                    }
                    this.context.setManager(manager);
                }
                if (contextMetaData.getParameters() != null) {
                    for (ParameterMetaData parameterMetaData : contextMetaData.getParameters()) {
                        this.context.addApplicationParameter((ApplicationParameter)TomcatService.getInstance(parameterMetaData, null));
                    }
                }
                if (contextMetaData.getResources() != null) {
                    this.context.setResources((DirContext)TomcatService.getInstance(contextMetaData.getResources(), "org.apache.naming.resources.FileDirContext"));
                }
                if (contextMetaData.getSessionCookie() != null) {
                    SessionCookie sessionCookie = new SessionCookie();
                    sessionCookie.setComment(contextMetaData.getSessionCookie().getComment());
                    sessionCookie.setDomain(contextMetaData.getSessionCookie().getDomain());
                    sessionCookie.setHttpOnly(contextMetaData.getSessionCookie().getHttpOnly());
                    sessionCookie.setPath(contextMetaData.getSessionCookie().getPath());
                    sessionCookie.setSecure(contextMetaData.getSessionCookie().getSecure());
                    this.context.setSessionCookie(sessionCookie);
                }
                if (contextMetaData.getWrapperLifecycles() != null) {
                    listeners = contextMetaData.getWrapperLifecycles().iterator();
                    while (listeners.hasNext()) {
                        this.context.addWrapperLifecycle(listeners.next());
                    }
                }
                if (contextMetaData.getWrapperListeners() != null) {
                    listeners = contextMetaData.getWrapperListeners().iterator();
                    while (listeners.hasNext()) {
                        this.context.addWrapperListener(listeners.next());
                    }
                }
                if (contextMetaData.getOverlays() != null) {
                    this.overlays.addAll(contextMetaData.getOverlays());
                }
            }
            catch (Exception e) {
                log.error((Object)("Error processing: " + resourceName), (Throwable)e);
                this.ok = false;
            }
        }
    }

    protected void destroy() {
        if (this.runDestroy) {
            super.destroy();
        }
    }

    protected void applicationTldConfig() {
        Map<String, TldMetaData> tldMetaDataMap = tldMetaDataMapLocal.get();
        if (tldMetaDataMap == null) {
            return;
        }
        ArrayList<TagLibraryInfo> tagLibraries = new ArrayList<TagLibraryInfo>();
        Iterator<String> locationInterator = tldMetaDataMap.keySet().iterator();
        while (locationInterator.hasNext()) {
            int pos;
            String relativeLocation = null;
            String jarPath = null;
            String location = locationInterator.next();
            TldMetaData tldMetaData = tldMetaDataMap.get(location);
            if (!location.startsWith("shared:") && (relativeLocation = "/" + location.substring(TldMetaData.class.getName().length() + 1)).startsWith("/WEB-INF/lib/") && (pos = relativeLocation.indexOf(47, "/WEB-INF/lib/".length())) > 0) {
                jarPath = relativeLocation.substring(pos);
                if (jarPath.startsWith("/")) {
                    jarPath = jarPath.substring(1);
                }
                relativeLocation = relativeLocation.substring(0, pos);
            }
            TagLibraryInfo tagLibraryInfo = new TagLibraryInfo();
            tagLibraryInfo.setTlibversion(tldMetaData.getTlibVersion());
            if (tldMetaData.getJspVersion() == null) {
                tagLibraryInfo.setJspversion(tldMetaData.getVersion());
            } else {
                tagLibraryInfo.setJspversion(tldMetaData.getJspVersion());
            }
            tagLibraryInfo.setShortname(tldMetaData.getShortName());
            tagLibraryInfo.setUri(tldMetaData.getUri());
            if (tldMetaData.getDescriptionGroup() != null) {
                tagLibraryInfo.setInfo(tldMetaData.getDescriptionGroup().getDescription());
            }
            if (tldMetaData.getListeners() != null) {
                for (ListenerMetaData listener : tldMetaData.getListeners()) {
                    tagLibraryInfo.addListener(listener.getListenerClass());
                }
            }
            if (tldMetaData.getValidator() != null) {
                TagLibraryValidatorInfo tagLibraryValidatorInfo = new TagLibraryValidatorInfo();
                tagLibraryValidatorInfo.setValidatorClass(tldMetaData.getValidator().getValidatorClass());
                if (tldMetaData.getValidator().getInitParams() != null) {
                    for (ParamValueMetaData paramValueMetaData : tldMetaData.getValidator().getInitParams()) {
                        tagLibraryValidatorInfo.addInitParam(paramValueMetaData.getParamName(), (Object)paramValueMetaData.getParamValue());
                    }
                }
                tagLibraryInfo.setValidator(tagLibraryValidatorInfo);
            }
            if (tldMetaData.getTags() != null) {
                for (TagMetaData tagMetaData : tldMetaData.getTags()) {
                    TagInfo tagInfo = new TagInfo();
                    tagInfo.setTagName(tagMetaData.getName());
                    tagInfo.setTagClassName(tagMetaData.getTagClass());
                    tagInfo.setTagExtraInfo(tagMetaData.getTeiClass());
                    if (tagMetaData.getBodyContent() != null) {
                        tagInfo.setBodyContent(tagMetaData.getBodyContent().toString());
                    }
                    tagInfo.setDynamicAttributes(tagMetaData.getDynamicAttributes());
                    if (tagMetaData.getDescriptionGroup() != null) {
                        DescriptionGroupMetaData descriptionGroup = tagMetaData.getDescriptionGroup();
                        if (descriptionGroup.getIcons() != null && descriptionGroup.getIcons().value() != null && descriptionGroup.getIcons().value().length > 0) {
                            Icon icon = descriptionGroup.getIcons().value()[0];
                            tagInfo.setLargeIcon(icon.largeIcon());
                            tagInfo.setSmallIcon(icon.smallIcon());
                        }
                        tagInfo.setInfoString(descriptionGroup.getDescription());
                        tagInfo.setDisplayName(descriptionGroup.getDisplayName());
                    }
                    if (tagMetaData.getVariables() != null) {
                        for (VariableMetaData variableMetaData : tagMetaData.getVariables()) {
                            TagVariableInfo tagVariableInfo = new TagVariableInfo();
                            tagVariableInfo.setNameGiven(variableMetaData.getNameGiven());
                            tagVariableInfo.setNameFromAttribute(variableMetaData.getNameFromAttribute());
                            tagVariableInfo.setClassName(variableMetaData.getVariableClass());
                            tagVariableInfo.setDeclare(variableMetaData.getDeclare());
                            if (variableMetaData.getScope() != null) {
                                tagVariableInfo.setScope(variableMetaData.getScope().toString());
                            }
                            tagInfo.addTagVariableInfo(tagVariableInfo);
                        }
                    }
                    if (tagMetaData.getAttributes() != null) {
                        for (AttributeMetaData attributeMetaData : tagMetaData.getAttributes()) {
                            TagAttributeInfo tagAttributeInfo = new TagAttributeInfo();
                            tagAttributeInfo.setName(attributeMetaData.getName());
                            tagAttributeInfo.setType(attributeMetaData.getType());
                            tagAttributeInfo.setReqTime(attributeMetaData.getRtexprvalue());
                            tagAttributeInfo.setRequired(attributeMetaData.getRequired());
                            tagAttributeInfo.setFragment(attributeMetaData.getFragment());
                            if (attributeMetaData.getDeferredValue() != null) {
                                tagAttributeInfo.setDeferredValue("true");
                                tagAttributeInfo.setExpectedTypeName(attributeMetaData.getDeferredValue().getType());
                            } else {
                                tagAttributeInfo.setDeferredValue("false");
                            }
                            if (attributeMetaData.getDeferredMethod() != null) {
                                tagAttributeInfo.setDeferredMethod("true");
                                tagAttributeInfo.setMethodSignature(attributeMetaData.getDeferredMethod().getMethodSignature());
                            } else {
                                tagAttributeInfo.setDeferredMethod("false");
                            }
                            tagInfo.addTagAttributeInfo(tagAttributeInfo);
                        }
                    }
                    tagLibraryInfo.addTagInfo(tagInfo);
                }
            }
            if (tldMetaData.getTagFiles() != null) {
                for (TagFileMetaData tagFileMetaData : tldMetaData.getTagFiles()) {
                    TagFileInfo tagFileInfo = new TagFileInfo();
                    tagFileInfo.setName(tagFileMetaData.getName());
                    tagFileInfo.setPath(tagFileMetaData.getPath());
                    tagLibraryInfo.addTagFileInfo(tagFileInfo);
                }
            }
            if (tldMetaData.getFunctions() != null) {
                for (FunctionMetaData functionMetaData : tldMetaData.getFunctions()) {
                    FunctionInfo functionInfo = new FunctionInfo();
                    functionInfo.setName(functionMetaData.getName());
                    functionInfo.setFunctionClass(functionMetaData.getFunctionClass());
                    functionInfo.setFunctionSignature(functionMetaData.getFunctionSignature());
                    tagLibraryInfo.addFunctionInfo(functionInfo);
                }
            }
            if (jarPath == null && relativeLocation == null) {
                this.context.addJspTagLibrary(tagLibraryInfo);
                continue;
            }
            if (jarPath == null) {
                tagLibraryInfo.setLocation("");
                tagLibraryInfo.setPath(relativeLocation);
                tagLibraries.add(tagLibraryInfo);
                this.context.addJspTagLibrary(tagLibraryInfo);
                this.context.addJspTagLibrary(relativeLocation, tagLibraryInfo);
                continue;
            }
            tagLibraryInfo.setLocation(relativeLocation);
            tagLibraryInfo.setPath(jarPath);
            tagLibraries.add(tagLibraryInfo);
            this.context.addJspTagLibrary(tagLibraryInfo);
            if (!jarPath.equals("META-INF/taglib.tld")) continue;
            this.context.addJspTagLibrary(relativeLocation, tagLibraryInfo);
        }
        String[] taglibs = this.context.findTaglibs();
        for (int i = 0; i < taglibs.length; ++i) {
            String uri = taglibs[i];
            String path = this.context.findTaglib(taglibs[i]);
            String location = "";
            if (path.indexOf(58) == -1 && !path.startsWith("/")) {
                path = "/WEB-INF/" + path;
            }
            if (path.endsWith(".jar")) {
                location = path;
                path = "META-INF/taglib.tld";
            }
            for (int j = 0; j < tagLibraries.size(); ++j) {
                TagLibraryInfo tagLibraryInfo = (TagLibraryInfo)tagLibraries.get(j);
                if (!tagLibraryInfo.getLocation().equals(location) || !tagLibraryInfo.getPath().equals(path)) continue;
                this.context.addJspTagLibrary(uri, tagLibraryInfo);
            }
        }
    }

    public void applicationServletContainerInitializerConfig() {
    }

    protected void createFragmentsOrder() {
    }

    protected void applicationExtraDescriptorsConfig() {
    }

    protected void resolveAnnotations(JBossAnnotationsMetaData annotations) {
        if (annotations != null) {
            for (JBossAnnotationMetaData annotation : annotations) {
                String className = annotation.getClassName();
                Container[] wrappers = this.context.findChildren();
                for (int i = 0; i < wrappers.length; ++i) {
                    Wrapper wrapper = (Wrapper)wrappers[i];
                    if (!className.equals(wrapper.getServletClass())) continue;
                    if (annotation.getRunAs() != null && wrapper.getRunAs() == null) {
                        wrapper.setRunAs(annotation.getRunAs().getRoleName());
                    }
                    if (annotation.getMultipartConfig() != null && wrapper.getMultipartConfig() == null) {
                        MultipartConfigMetaData multipartConfigMetaData = annotation.getMultipartConfig();
                        Multipart multipartConfig = new Multipart();
                        multipartConfig.setLocation(multipartConfigMetaData.getLocation());
                        multipartConfig.setMaxRequestSize(multipartConfigMetaData.getMaxRequestSize());
                        multipartConfig.setMaxFileSize(multipartConfigMetaData.getMaxFileSize());
                        multipartConfig.setFileSizeThreshold(multipartConfigMetaData.getFileSizeThreshold());
                        wrapper.setMultipartConfig(multipartConfig);
                    }
                    if (annotation.getServletSecurity() == null || wrapper.getServletSecurity() != null) continue;
                    ServletSecurityMetaData servletSecurityAnnotation = annotation.getServletSecurity();
                    HashSet<HttpMethodConstraintElement> methodConstraints = null;
                    ServletSecurity.EmptyRoleSemantic emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.PERMIT;
                    if (servletSecurityAnnotation.getEmptyRoleSemantic() != null) {
                        emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.valueOf((String)servletSecurityAnnotation.getEmptyRoleSemantic().toString());
                    }
                    ServletSecurity.TransportGuarantee transportGuarantee = ServletSecurity.TransportGuarantee.NONE;
                    if (servletSecurityAnnotation.getTransportGuarantee() != null) {
                        transportGuarantee = ServletSecurity.TransportGuarantee.valueOf((String)servletSecurityAnnotation.getTransportGuarantee().toString());
                    }
                    String[] roleNames = servletSecurityAnnotation.getRolesAllowed().toArray(new String[0]);
                    HttpConstraintElement constraint = new HttpConstraintElement(emptyRoleSemantic, transportGuarantee, roleNames);
                    if (servletSecurityAnnotation.getHttpMethodConstraints() != null) {
                        methodConstraints = new HashSet<HttpMethodConstraintElement>();
                        for (HttpMethodConstraintMetaData annotationMethodConstraint : servletSecurityAnnotation.getHttpMethodConstraints()) {
                            emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.PERMIT;
                            if (annotationMethodConstraint.getEmptyRoleSemantic() != null) {
                                emptyRoleSemantic = ServletSecurity.EmptyRoleSemantic.valueOf((String)annotationMethodConstraint.getEmptyRoleSemantic().toString());
                            }
                            transportGuarantee = ServletSecurity.TransportGuarantee.NONE;
                            if (annotationMethodConstraint.getTransportGuarantee() != null) {
                                transportGuarantee = ServletSecurity.TransportGuarantee.valueOf((String)annotationMethodConstraint.getTransportGuarantee().toString());
                            }
                            roleNames = annotationMethodConstraint.getRolesAllowed().toArray(new String[0]);
                            HttpConstraintElement constraint2 = new HttpConstraintElement(emptyRoleSemantic, transportGuarantee, roleNames);
                            HttpMethodConstraintElement methodConstraint = new HttpMethodConstraintElement(annotationMethodConstraint.getMethod(), constraint2);
                            methodConstraints.add(methodConstraint);
                        }
                    }
                    ServletSecurityElement servletSecurity = new ServletSecurityElement(constraint, methodConstraints);
                    wrapper.setServletSecurity(servletSecurity);
                }
            }
        }
    }

    protected Manager initManager(ManagerMetaData managerMetaData) throws Exception, ClusteringNotSupportedException, NoClassDefFoundError {
        JBossWebMetaData webMetaData = metaDataLocal.get();
        String defaultManagerClass = webMetaData.getDistributable() == null ? StandardManager.class.getName() : JBossCacheManager.class.getName();
        Manager manager = (Manager)TomcatService.getInstance(managerMetaData, defaultManagerClass);
        if (manager instanceof AbstractJBossManager) {
            Host host = null;
            Context container = this.context;
            while (host == null && container != null) {
                if (!((container = container.getParent()) instanceof Host)) continue;
                host = (Host)container;
            }
            String hostName = host.getName();
            String name = "//" + (hostName == null ? "localhost" : hostName) + webMetaData.getContextRoot();
            try {
                ((AbstractJBossManager)manager).init(name, webMetaData);
            }
            catch (ClusteringNotSupportedException e) {
                if (managerMetaData.getClassName() == null) {
                    log.warn((Object)("Failed to setup clustering, clustering disabled. ClusteringNotSupportedException: " + e.getMessage()));
                    manager = (Manager)TomcatService.getInstance(managerMetaData, StandardManager.class.getName());
                }
                throw e;
            }
            catch (NoClassDefFoundError ncdf) {
                if (managerMetaData.getClassName() == null) {
                    log.debug((Object)"Classes needed for clustered webapp unavailable", (Throwable)ncdf);
                    log.warn((Object)("Failed to setup clustering, clustering disabled. NoClassDefFoundError: " + ncdf.getMessage()));
                    manager = (Manager)TomcatService.getInstance(managerMetaData, StandardManager.class.getName());
                }
                throw ncdf;
            }
        }
        return manager;
    }

    protected void completeConfig() {
        Set overlays;
        JBossWebMetaData metaData = metaDataLocal.get();
        if (this.ok && metaData != null) {
            metaData.resolveAnnotations();
            this.resolveAnnotations(metaData.getAnnotations());
        }
        if (this.ok) {
            this.resolveServletSecurity();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok && metaData != null) {
            metaData.resolveRunAs();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        DeploymentUnit deploymentUnit = deploymentUnitLocal.get();
        if (this.ok && deploymentUnit != null && (overlays = (Set)deploymentUnit.getAttachment(MergedJBossWebMetaDataDeployer.WEB_OVERLAYS_ATTACHMENT_NAME)) != null) {
            if (this.context.getResources() instanceof ProxyDirContext) {
                ProxyDirContext resources = (ProxyDirContext)this.context.getResources();
                for (VirtualFile overlay : overlays) {
                    FileDirContext dirContext = new FileDirContext();
                    try {
                        dirContext.setDocBase(overlay.getPhysicalFile().getAbsolutePath());
                        resources.addOverlay((DirContext)dirContext);
                    }
                    catch (IOException e) {
                        log.error((Object)sm.getString("contextConfig.noOverlay", (Object)this.context.getName()), (Throwable)e);
                        this.ok = false;
                        break;
                    }
                }
            } else if (overlays.size() > 0) {
                log.error((Object)sm.getString("contextConfig.noOverlay", (Object)this.context.getName()));
                this.ok = false;
            }
        }
        if (this.ok) {
            for (String overlay : this.overlays) {
                if (!(this.context.getResources() instanceof ProxyDirContext)) continue;
                ProxyDirContext resources = (ProxyDirContext)this.context.getResources();
                FileDirContext dirContext = new FileDirContext();
                dirContext.setDocBase(overlay);
                resources.addOverlay((DirContext)dirContext);
            }
        }
        if (!this.ok) {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }
}

