/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gradle.plugins.jdocbook.task;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class ScriptClassLoaderExtender {
    private static final Logger log = Logging.getLogger((String)ScriptClassLoaderExtender.class.getName());

    public static synchronized Result extendScriptClassLoader(Project project) {
        log.lifecycle("Extending script classloader with the {} dependencies", new Object[]{"jdocbookXsl"});
        ArrayList<URL> xslDepUrls = null;
        Set xslDepFiles = project.getConfigurations().getByName("jdocbookXsl").getFiles();
        if (!xslDepFiles.isEmpty()) {
            xslDepUrls = new ArrayList<URL>();
            for (File xslDepFile : xslDepFiles) {
                try {
                    log.trace("  Adding artifact to script classloader extension : " + xslDepFile.getPath());
                    xslDepUrls.add(xslDepFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    log.warn("Unable to retrieve file url [{}]; ignoring", (Object)xslDepFile.getAbsolutePath());
                }
            }
        }
        Result tcclResult = new Result(Thread.currentThread().getContextClassLoader());
        if (xslDepUrls == null) {
            Thread.currentThread().setContextClassLoader(project.getBuildscript().getClassLoader());
        } else {
            URLClassLoader extendedClassLoader = new URLClassLoader(xslDepUrls.toArray(new URL[xslDepUrls.size()]), project.getBuildscript().getClassLoader());
            Thread.currentThread().setContextClassLoader(extendedClassLoader);
        }
        return tcclResult;
    }

    public static synchronized void unextendScriptClassLoader(Result extensionResult) {
        Thread.currentThread().setContextClassLoader(extensionResult.originalTccl);
    }

    public static class Result {
        private final ClassLoader originalTccl;

        private Result(ClassLoader originalTccl) {
            this.originalTccl = originalTccl;
        }
    }
}

