/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceTextValueMetaData;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueFactoryParameterMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceValueFactoryValueMetaData
extends AbstractMetaDataVisitorNode
implements ServiceValueMetaData,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Object dependency;
    private final String method;
    private final ServiceTextValueMetaData defaultValue;
    private final List<ServiceValueFactoryParameterMetaData> parameterMetaData;
    private Object[] parameterValues;
    private String[] parameterTypes;
    private final ControllerState dependentState;

    public ServiceValueFactoryValueMetaData(Object dependency, String method, List<ServiceValueFactoryParameterMetaData> parameters, ControllerState dependentState, ServiceTextValueMetaData defaultValue) {
        if (dependency == null) {
            throw new IllegalArgumentException("Null dependency");
        }
        this.dependency = dependency;
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        this.method = method;
        this.parameterMetaData = parameters == null ? Collections.emptyList() : parameters;
        this.dependentState = dependentState == null ? ControllerState.INSTALLED : dependentState;
        this.defaultValue = defaultValue;
    }

    public Object getDependency() {
        return this.dependency;
    }

    public String getMethod() {
        return this.method;
    }

    public List<ServiceValueFactoryParameterMetaData> getParameterMetaData() {
        return this.parameterMetaData;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public ServiceTextValueMetaData getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Object getValue(ServiceValueContext valueContext) throws Throwable {
        ControllerContext factoryContext;
        KernelController controller = valueContext.getController();
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((factoryContext = controller.getContext(this.dependency, state)) == null) {
            throw new Error("Should not be here - dependency failed! " + this);
        }
        if (!(factoryContext instanceof InvokeDispatchContext)) {
            throw new IllegalArgumentException("Cannot use property attribute, context is not InvokeDispatchContext: " + factoryContext + ", metadata: " + this);
        }
        InvokeDispatchContext idc = (InvokeDispatchContext)factoryContext;
        Object result = idc.invoke(this.method, this.getParameterValues(valueContext, factoryContext), this.getParameterTypes(valueContext, factoryContext));
        if (result == null && this.defaultValue != null) {
            result = this.defaultValue.getValue(valueContext);
        }
        return result;
    }

    @Override
    public Object ungetValue(ServiceValueContext valueContext) throws Throwable {
        for (ServiceValueFactoryParameterMetaData metadata : this.parameterMetaData) {
            metadata.ungetValue(valueContext);
        }
        return null;
    }

    @Override
    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context = visitor.getControllerContext();
        Object name = context.getName();
        ControllerState whenRequired = visitor.getContextState();
        AbstractDependencyItem item = new AbstractDependencyItem(name, this.dependency, whenRequired, this.dependentState);
        visitor.addDependency((DependencyItem)item);
        visitor.visit(this);
    }

    private Object[] getParameterValues(ServiceValueContext valueContext, ControllerContext factoryContext) throws Exception {
        if (this.parameterValues != null) {
            return this.parameterValues;
        }
        if (factoryContext instanceof KernelControllerContext) {
            this.analyzeParameters(valueContext, (KernelControllerContext)factoryContext);
        } else {
            this.extractParameters(valueContext);
        }
        return this.parameterValues;
    }

    private String[] getParameterTypes(ServiceValueContext valueContext, ControllerContext factoryContext) throws Exception {
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        if (factoryContext instanceof KernelControllerContext) {
            this.analyzeParameters(valueContext, (KernelControllerContext)factoryContext);
        } else {
            this.extractParameters(valueContext);
        }
        return this.parameterTypes;
    }

    private void analyzeParameters(ServiceValueContext valueContext, KernelControllerContext factoryContext) throws Exception {
        BeanInfo beanInfo = factoryContext.getBeanInfo();
        Set allMethods = beanInfo.getMethods();
        ServiceValueFactoryValueMetaData.populateParameterTypes(allMethods, this.method, this.parameterMetaData);
        this.parameterTypes = new String[this.parameterMetaData.size()];
        this.parameterValues = new Object[this.parameterMetaData.size()];
        for (int i = 0; i < this.parameterMetaData.size(); ++i) {
            ServiceValueFactoryParameterMetaData metadata = this.parameterMetaData.get(i);
            this.parameterTypes[i] = metadata.getParameterTypeName();
            this.parameterValues[i] = metadata.getValue(valueContext);
        }
    }

    private void extractParameters(ServiceValueContext valueContext) throws Exception {
        this.parameterTypes = new String[this.parameterMetaData.size()];
        this.parameterValues = new Object[this.parameterMetaData.size()];
        for (int i = 0; i < this.parameterMetaData.size(); ++i) {
            ServiceValueFactoryParameterMetaData metadata = this.parameterMetaData.get(i);
            this.parameterTypes[i] = metadata.getParameterTypeName();
            if (this.parameterTypes[i] == null) {
                this.parameterTypes = null;
                this.parameterValues = null;
                throw new IllegalStateException("No type available for parameter " + i + " -- parameter types must be specified to invoke on mbeans");
            }
            this.parameterValues[i] = metadata.getValue(valueContext);
        }
    }

    public static void populateParameterTypes(Set<MethodInfo> allMethods, String methodName, List<ServiceValueFactoryParameterMetaData> parameterMetaData) {
        ArrayList<MethodInfo> possibleMatches = new ArrayList<MethodInfo>();
        for (MethodInfo mi : allMethods) {
            TypeInfo[] typeInfos = mi.getParameterTypes();
            if (!methodName.equals(mi.getName()) || typeInfos.length != parameterMetaData.size()) continue;
            boolean match = true;
            for (int i = 0; i < typeInfos.length; ++i) {
                String ourType = parameterMetaData.get(i).getParameterTypeName();
                if (ourType == null || ourType.equals(typeInfos[i].getName())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            possibleMatches.add(mi);
        }
        if (possibleMatches.size() == 1) {
            MethodInfo match = (MethodInfo)possibleMatches.get(0);
            TypeInfo[] types = match.getParameterTypes();
            for (int i = 0; i < types.length; ++i) {
                ServiceValueFactoryParameterMetaData metadata = parameterMetaData.get(i);
                if (metadata.getParameterTypeName() != null) continue;
                metadata.setParameterTypeName(types[i].getName());
            }
        } else {
            if (possibleMatches.size() == 0) {
                throw new IllegalArgumentException("Cannot match parameters to any method.");
            }
            throw new IllegalArgumentException("Cannot match parameters to a single method. Possible matches : " + possibleMatches);
        }
    }
}

