/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dispatch;

import java.util.List;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dispatch.SecurityActions;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeDispatchHelper {
    private static final Logger log = Logger.getLogger(InvokeDispatchHelper.class);

    public static Object invoke(KernelConfigurator configurator, InvokeDispatchContext context, String methodName, List<ParameterMetaData> params, boolean unget) throws Throwable {
        Object[] parameters;
        String[] signature;
        if (params == null || params.isEmpty()) {
            signature = new String[]{};
            parameters = new Object[]{};
        } else {
            Object target = context instanceof ControllerContext ? ((ControllerContext)ControllerContext.class.cast(context)).getTarget() : null;
            int size = params.size();
            signature = Configurator.getParameterTypes(log.isTraceEnabled(), params);
            ClassLoader classLoader = SecurityActions.getClassLoader(context);
            if (target != null) {
                ClassInfo classInfo = configurator.getClassInfo(target.getClass());
                MethodInfo methodInfo = Configurator.findMethodInfo((ClassInfo)classInfo, (String)methodName, (String[])signature);
                TypeInfo[] infos = methodInfo.getParameterTypes();
                parameters = Configurator.handleParameters(log.isTraceEnabled(), classLoader, infos, params, unget);
                for (int i = 0; i < size; ++i) {
                    if (signature[i] != null || infos[i] == null) continue;
                    signature[i] = infos[i].getName();
                }
            } else {
                parameters = new Object[size];
                for (int i = 0; i < size; ++i) {
                    ParameterMetaData pmd = params.get(i);
                    ClassInfo typeInfo = null;
                    if (signature[i] != null) {
                        typeInfo = configurator.getClassInfo(signature[i], classLoader);
                    }
                    ValueMetaData vmd = pmd.getValue();
                    if (unget) {
                        vmd.ungetValue((TypeInfo)typeInfo, classLoader);
                        continue;
                    }
                    parameters[i] = vmd.getValue((TypeInfo)typeInfo, classLoader);
                }
            }
        }
        return !unget ? context.invoke(methodName, parameters, signature) : null;
    }
}

