/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.api.model.QualifierPoint;
import org.jboss.beans.metadata.api.model.QualifierType;
import org.jboss.beans.metadata.plugins.AbstractBeanQualifierMetaData;
import org.jboss.beans.metadata.plugins.ContextualInjectionDependencyItem;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.RelatedClassMetaData;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataItem;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.RetrievalUtils;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.DeclaredMethodSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactoryImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.collection.ConcurrentSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiersMdrUtil {
    private static final Logger log = Logger.getLogger(QualifiersMdrUtil.class);
    private static final MDRStrategy SUPPLIED_MDR = new SuppliedMDRStrategy();
    private static final MDRStrategy WANTED_MDR = new WantedMDRStrategy();
    public static final String SUPPLIED_QUALIFIER_KEY = QualifiersMdrUtil.class.getSimpleName() + "#SUPPLIED_QUALIFIERS";
    public static final String REQUIRED_QUALIFIER_KEY = QualifiersMdrUtil.class.getSimpleName() + "#REQUIRED_QUALIFIERS";
    public static final String OPTIONAL_QUALIFIER_KEY = QualifiersMdrUtil.class.getSimpleName() + "#OPTIONAL_QUALIFIERS";
    public static final String CONSTRUCTOR_SUFFIX = "#CONSTRUCTOR";
    public static final String PROPERTY_SUFFIX = "#PROPERTY";
    public static final String METHOD_SUFFIX = "#METHOD";
    private static final Class<? extends Annotation>[] QUALIFIERS = new Class[]{Qualifier.class};
    private static final TypeInfo BEAN_FACTORY_TYPE;

    public static boolean hasWantedQualifiersInParentMdrOrBeanMetaData(KernelControllerContext context, QualifierPoint point) {
        Set<RelatedClassMetaData> related = context.getBeanMetaData().getRelated();
        if (related == null) {
            return false;
        }
        if (related.size() == 0) {
            return false;
        }
        HashSet<RelatedClassMetaData> md = null;
        for (RelatedClassMetaData rcmd : related) {
            if (!rcmd.getClassName().equals(REQUIRED_QUALIFIER_KEY) && !rcmd.getClassName().equals(OPTIONAL_QUALIFIER_KEY)) continue;
            if (md == null) {
                md = new HashSet<RelatedClassMetaData>();
            }
            md.add(rcmd);
        }
        if (md != null && md.size() > 0) {
            return true;
        }
        MutableMetaDataRepository repository = context.getKernel().getMetaDataRepository().getMetaDataRepository();
        for (ScopeKey key = context.getScopeInfo().getScope(); key != null; key = key.getParent()) {
            MetaData metaData = repository.getMetaData(key);
            if (metaData == null) continue;
            if (metaData.getMetaData(WANTED_MDR.getKey(REQUIRED_QUALIFIER_KEY, point)) != null) {
                return true;
            }
            if (metaData.getMetaData(WANTED_MDR.getKey(OPTIONAL_QUALIFIER_KEY, point)) == null) continue;
            return true;
        }
        return false;
    }

    public static void populateQualifiersForContext(KernelControllerContext context) throws Exception {
        Set<RelatedClassMetaData> qualifiers = context.getBeanMetaData().getRelated();
        if (qualifiers != null && qualifiers.size() > 0) {
            MetaDataRetrieval retrieval = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaDataRetrieval(context.getScopeInfo().getMutableScope());
            if (!(retrieval instanceof MutableMetaData)) {
                log.warn((Object)("Can not add qualifier to non mutable metadata" + context + ":" + retrieval));
                return;
            }
            HashSet<RelatedClassMetaData> suppliedMetaData = new HashSet<RelatedClassMetaData>();
            HashSet<RelatedClassMetaData> requiredMetaData = new HashSet<RelatedClassMetaData>();
            HashSet<RelatedClassMetaData> optionalMetaData = new HashSet<RelatedClassMetaData>();
            QualifiersMdrUtil.splitRelatedClassMetaData(qualifiers, suppliedMetaData, requiredMetaData, optionalMetaData);
            for (RelatedClassMetaData rcmd : qualifiers) {
                if (JBossObject.equals((Object)SUPPLIED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                    SUPPLIED_MDR.addQualifiersToSetInMdr(suppliedMetaData, rcmd.getClassName(), retrieval);
                    continue;
                }
                if (JBossObject.equals((Object)REQUIRED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                    WANTED_MDR.addQualifiersToSetInMdr(requiredMetaData, rcmd.getClassName(), retrieval);
                    continue;
                }
                if (!JBossObject.equals((Object)OPTIONAL_QUALIFIER_KEY, (Object)rcmd.getClassName())) continue;
                WANTED_MDR.addQualifiersToSetInMdr(optionalMetaData, rcmd.getClassName(), retrieval);
            }
        }
        QualifiersMdrUtil.addQualifiersFromQualifierAnnotations(context);
    }

    public static Set<Annotation> getQualifiersFromAnnotationsForInjectionPointParents(KernelControllerContext context, List<MetaDataVisitorNode> parents) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        MetaData metaData = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaData(context.getScopeInfo().getScope());
        if (metaData == null) {
            return null;
        }
        return QualifiersMdrUtil.getQualifiersFromAnnotationsForInjectionPointParents(context, parents, metaData);
    }

    public static void addQualifiersToMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
        switch (type) {
            case SUPPLIED: {
                SUPPLIED_MDR.addQualifiersToMdrRetrieval(retrieval, type, point, qualifiers);
                break;
            }
            case REQUIRED: 
            case OPTIONAL: {
                WANTED_MDR.addQualifiersToMdrRetrieval(retrieval, type, point, qualifiers);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type));
            }
        }
    }

    public static void removeQualifiersFromMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
        switch (type) {
            case SUPPLIED: {
                SUPPLIED_MDR.removeQualifiersFromMdrRetrieval(retrieval, type, point, qualifiers);
                break;
            }
            case REQUIRED: 
            case OPTIONAL: {
                WANTED_MDR.removeQualifiersFromMdrRetrieval(retrieval, type, point, qualifiers);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type));
            }
        }
    }

    public static void removeQualifiersFromMdr(KernelControllerContext context) {
        Set<RelatedClassMetaData> qualifiers = context.getBeanMetaData().getRelated();
        if (qualifiers != null && qualifiers.size() > 0) {
            MetaDataRetrieval retrieval = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaDataRetrieval(context.getScopeInfo().getMutableScope());
            if (!(retrieval instanceof MutableMetaData)) {
                log.warn((Object)("Can not remove qualifier from non mutable metadata" + context + ":" + retrieval));
                return;
            }
            HashSet<RelatedClassMetaData> suppliedMetaData = new HashSet<RelatedClassMetaData>();
            HashSet<RelatedClassMetaData> requiredMetaData = new HashSet<RelatedClassMetaData>();
            HashSet<RelatedClassMetaData> optionalMetaData = new HashSet<RelatedClassMetaData>();
            QualifiersMdrUtil.splitRelatedClassMetaData(qualifiers, suppliedMetaData, requiredMetaData, optionalMetaData);
            for (RelatedClassMetaData rcmd : qualifiers) {
                if (JBossObject.equals((Object)SUPPLIED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                    SUPPLIED_MDR.removeQualifiersFromSetInMdr(suppliedMetaData, rcmd.getClassName(), retrieval);
                    continue;
                }
                if (JBossObject.equals((Object)REQUIRED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                    WANTED_MDR.removeQualifiersFromSetInMdr(requiredMetaData, rcmd.getClassName(), retrieval);
                    continue;
                }
                if (!JBossObject.equals((Object)OPTIONAL_QUALIFIER_KEY, (Object)rcmd.getClassName())) continue;
                WANTED_MDR.removeQualifiersFromSetInMdr(optionalMetaData, rcmd.getClassName(), retrieval);
            }
        }
    }

    public static Set<Object> mergeSuppliedQualifiersFromMdr(ControllerContext context) {
        return SUPPLIED_MDR.mergeQualifiersFromMdr(context, QualifierType.SUPPLIED, null);
    }

    public static Set<Object> mergeRequiredQualifiersFromMdr(ControllerContext context, QualifierPoint point) {
        return WANTED_MDR.mergeQualifiersFromMdr(context, QualifierType.REQUIRED, point);
    }

    public static Set<Object> mergeOptionalQualifiersFromMdr(ControllerContext context, QualifierPoint point) {
        return WANTED_MDR.mergeQualifiersFromMdr(context, QualifierType.OPTIONAL, point);
    }

    public static String getKey(QualifierType type, QualifierPoint point) {
        switch (type) {
            case REQUIRED: 
            case OPTIONAL: {
                return WANTED_MDR.getKey(type, point);
            }
            case SUPPLIED: {
                return SUPPLIED_MDR.getKey(type, point);
            }
        }
        throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type));
    }

    private static void splitRelatedClassMetaData(Set<RelatedClassMetaData> related, Set<RelatedClassMetaData> suppliedMetaData, Set<RelatedClassMetaData> requiredMetaData, Set<RelatedClassMetaData> optionalMetaData) {
        for (RelatedClassMetaData rcmd : related) {
            if (JBossObject.equals((Object)SUPPLIED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                suppliedMetaData.add(rcmd);
                continue;
            }
            if (JBossObject.equals((Object)REQUIRED_QUALIFIER_KEY, (Object)rcmd.getClassName())) {
                requiredMetaData.add(rcmd);
                continue;
            }
            if (!JBossObject.equals((Object)OPTIONAL_QUALIFIER_KEY, (Object)rcmd.getClassName())) continue;
            optionalMetaData.add(rcmd);
        }
    }

    private static void addQualifiersFromQualifierAnnotations(KernelControllerContext context) throws Exception {
        MetaData metaData = context.getKernel().getMetaDataRepository().getMetaDataRepository().getMetaData(context.getScopeInfo().getScope());
        for (DependencyItem item : context.getDependencyInfo().getIDependOn(ContextualInjectionDependencyItem.class)) {
            Set<Annotation> annotations = QualifiersMdrUtil.getQualifiersFromAnnotationsForInjectionPointParents(context, ((ContextualInjectionDependencyItem)item).getParents(), metaData);
            if (annotations == null || annotations.size() <= 0) continue;
            ((ContextualInjectionDependencyItem)item).addQualifierAnnotations(annotations);
        }
    }

    private static Set<Annotation> getQualifiersFromAnnotationsForInjectionPointParents(KernelControllerContext context, List<MetaDataVisitorNode> parents, MetaData metaData) throws Exception {
        Set<Annotation> annotationQualifiers = null;
        metaData = RetrievalUtils.createCachedMetaData((MetaData)metaData);
        block0: for (int i = 0; i < parents.size(); ++i) {
            MetaDataVisitorNode node = parents.get(i);
            if (node instanceof PropertyMetaData) {
                annotationQualifiers = QualifiersMdrUtil.populateQualifiersFromAnnotationsForProperty(context, metaData, (PropertyMetaData)node);
                continue;
            }
            if (!(node instanceof ParameterMetaData)) continue;
            ParameterMetaData pmd = (ParameterMetaData)node;
            ++i;
            while (i < parents.size()) {
                node = parents.get(i);
                if (node instanceof LifecycleMetaData) {
                    annotationQualifiers = QualifiersMdrUtil.populateQualifiersFromAnnotationsForMethod(context, metaData, pmd, (LifecycleMetaData)node);
                    break block0;
                }
                if (node instanceof ConstructorMetaData) {
                    annotationQualifiers = QualifiersMdrUtil.populateQualifiersFromAnnotationsForConstructor(context, metaData, pmd, (ConstructorMetaData)node);
                    break block0;
                }
                ++i;
            }
            break;
        }
        return annotationQualifiers;
    }

    private static Set<Annotation> populateQualifiersFromAnnotationsForProperty(KernelControllerContext context, MetaData metaData, PropertyMetaData property) {
        PropertyInfo info = context.getBeanInfo().getProperty(property.getName());
        MethodInfo setter = info.getSetter();
        if (setter != null) {
            MetaData methodMetaData = metaData.getComponentMetaData((Signature)new DeclaredMethodSignature(setter));
            MetaData paramMetaData = metaData.getComponentMetaData((Signature)new MethodParametersSignature(setter, 0));
            return QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData(methodMetaData, paramMetaData);
        }
        FieldInfo field = info.getFieldInfo();
        if (field != null) {
            MetaData fieldMetaData = metaData.getComponentMetaData((Signature)new FieldSignature(field));
            return QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData((Set<Annotation>)null, fieldMetaData);
        }
        MethodInfo getter = info.getGetter();
        if (getter != null) {
            MetaData methodMetaData = metaData.getComponentMetaData((Signature)new DeclaredMethodSignature(getter));
            return QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData((Set<Annotation>)null, methodMetaData);
        }
        return null;
    }

    private static Set<Annotation> populateQualifiersFromAnnotationsForConstructor(KernelControllerContext context, MetaData metaData, ParameterMetaData pmd, ConstructorMetaData cmd) throws Exception {
        if (cmd.getFactory() != null || cmd.getFactoryClass() != null || cmd.getFactoryMethod() != null || cmd.getValue() != null) {
            return null;
        }
        if (BEAN_FACTORY_TYPE.isAssignableFrom((TypeInfo)context.getBeanInfo().getClassInfo())) {
            return null;
        }
        ConstructorInfo ctor = Configurator.findConstructor(false, context.getBeanInfo(), cmd).getConstructorInfo();
        MetaData ctorMetaData = metaData.getComponentMetaData((Signature)new ConstructorSignature(ctor));
        MetaData paramMetaData = metaData.getComponentMetaData((Signature)new ConstructorParametersSignature(ctor, pmd.getIndex()));
        return QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData(ctorMetaData, paramMetaData);
    }

    private static Set<Annotation> populateQualifiersFromAnnotationsForMethod(KernelControllerContext context, MetaData metaData, ParameterMetaData pmd, LifecycleMetaData lmd) throws Exception {
        String[] paramTypes = new String[lmd.getParameters().size()];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = lmd.getParameters().get(i).getType();
        }
        MethodInfo method = Configurator.findMethodInfo((ClassInfo)context.getBeanInfo().getClassInfo(), (String)lmd.getMethodName(), (String[])paramTypes, (boolean)false);
        MetaData methodMetaData = metaData.getComponentMetaData((Signature)new DeclaredMethodSignature(method));
        MetaData paramMetaData = metaData.getComponentMetaData((Signature)new MethodParametersSignature(method, pmd.getIndex()));
        return QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData(methodMetaData, paramMetaData);
    }

    private static Set<Annotation> populateQualifiersFromAnnotationsMetaData(MetaData methodOrConstructor, MetaData parameter) {
        Set<Annotation> qualifiers = null;
        qualifiers = QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData(qualifiers, methodOrConstructor);
        qualifiers = QualifiersMdrUtil.populateQualifiersFromAnnotationsMetaData(qualifiers, parameter);
        return qualifiers;
    }

    private static Set<Annotation> populateQualifiersFromAnnotationsMetaData(Set<Annotation> qualifiers, MetaData metaData) {
        if (metaData == null) {
            return qualifiers;
        }
        for (Class<? extends Annotation> meta : QUALIFIERS) {
            for (Annotation annotation : metaData.getAnnotationsAnnotatedWith(meta)) {
                if (qualifiers == null) {
                    qualifiers = new HashSet<Annotation>();
                }
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    static {
        IntrospectionTypeInfoFactoryImpl factory = new IntrospectionTypeInfoFactoryImpl();
        BEAN_FACTORY_TYPE = factory.getTypeInfo(BeanFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WantedMDRStrategy
    extends MDRStrategy {
        private WantedMDRStrategy() {
        }

        @Override
        void addQualifiersToSetInMdr(Set<RelatedClassMetaData> relateds, String keyRoot, MetaDataRetrieval retrieval) {
            Set<Object> constructorSet = null;
            Set<Object> methodSet = null;
            Set<Object> propertySet = null;
            for (RelatedClassMetaData rcmd : relateds) {
                AbstractBeanQualifierMetaData aqmd;
                if (rcmd instanceof AbstractBeanQualifierMetaData && (aqmd = (AbstractBeanQualifierMetaData)rcmd).getPoints() != null && aqmd.getPoints().size() > 0) {
                    constructorSet = this.addQualifiersToSetInMdrIfHasCorrectType(constructorSet, retrieval, aqmd, QualifierPoint.CONSTRUCTOR);
                    methodSet = this.addQualifiersToSetInMdrIfHasCorrectType(methodSet, retrieval, aqmd, QualifierPoint.METHOD);
                    propertySet = this.addQualifiersToSetInMdrIfHasCorrectType(propertySet, retrieval, aqmd, QualifierPoint.PROPERTY);
                    continue;
                }
                constructorSet = this.addQualifiersToSetInMdr(constructorSet, retrieval, rcmd, QualifierPoint.CONSTRUCTOR);
                methodSet = this.addQualifiersToSetInMdr(methodSet, retrieval, rcmd, QualifierPoint.METHOD);
                propertySet = this.addQualifiersToSetInMdr(propertySet, retrieval, rcmd, QualifierPoint.PROPERTY);
            }
        }

        private Set<Object> addQualifiersToSetInMdrIfHasCorrectType(Set<Object> qualifierSet, MetaDataRetrieval retrieval, AbstractBeanQualifierMetaData aqmd, QualifierPoint point) {
            if (aqmd.getPoints().contains((Object)point)) {
                return this.addQualifiersToSetInMdr(qualifierSet, retrieval, aqmd, point);
            }
            return qualifierSet;
        }

        private Set<Object> addQualifiersToSetInMdr(Set<Object> qualifierSet, MetaDataRetrieval retrieval, RelatedClassMetaData rcmd, QualifierPoint point) {
            return this.addQualifiersToSetInMdr(qualifierSet, retrieval, this.getKey(rcmd.getClassName(), point), rcmd.getEnabled().toArray());
        }

        @Override
        void addQualifiersToMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
            if (point == null) {
                this.addQualifiersToSetInMdr(null, retrieval, this.getKey(type, QualifierPoint.CONSTRUCTOR), qualifiers);
                this.addQualifiersToSetInMdr(null, retrieval, this.getKey(type, QualifierPoint.METHOD), qualifiers);
                this.addQualifiersToSetInMdr(null, retrieval, this.getKey(type, QualifierPoint.PROPERTY), qualifiers);
            } else {
                this.addQualifiersToSetInMdr(null, retrieval, this.getKey(type, point), qualifiers);
            }
        }

        @Override
        void removeQualifiersFromSetInMdr(Set<RelatedClassMetaData> relateds, String keyRoot, MetaDataRetrieval retrieval) {
            if (relateds == null || relateds.size() == 0) {
                return;
            }
            Set<Object> constructorSet = this.getQualifiersSetInMdr(retrieval, this.getKey(keyRoot, QualifierPoint.CONSTRUCTOR), false);
            Set<Object> methodSet = this.getQualifiersSetInMdr(retrieval, this.getKey(keyRoot, QualifierPoint.METHOD), false);
            Set<Object> propertySet = this.getQualifiersSetInMdr(retrieval, this.getKey(keyRoot, QualifierPoint.PROPERTY), false);
            for (RelatedClassMetaData rcmd : relateds) {
                AbstractBeanQualifierMetaData aqmd;
                if (rcmd.getEnabled() == null || rcmd.getEnabled().size() <= 0 || !(rcmd instanceof AbstractBeanQualifierMetaData) || (aqmd = (AbstractBeanQualifierMetaData)rcmd).getPoints() == null || aqmd.getPoints().size() <= 0) continue;
                if (aqmd.getPoints().contains((Object)QualifierPoint.CONSTRUCTOR) && constructorSet != null) {
                    constructorSet.removeAll(aqmd.getEnabled());
                    continue;
                }
                if (aqmd.getPoints().contains((Object)QualifierPoint.METHOD) && methodSet != null) {
                    methodSet.removeAll(aqmd.getEnabled());
                    continue;
                }
                if (!aqmd.getPoints().contains((Object)QualifierPoint.PROPERTY) || propertySet == null) continue;
                propertySet.removeAll(aqmd.getEnabled());
            }
            this.removeEmptyQualifiersSetFromMdr(constructorSet, keyRoot, retrieval, QualifierPoint.CONSTRUCTOR);
            this.removeEmptyQualifiersSetFromMdr(methodSet, keyRoot, retrieval, QualifierPoint.METHOD);
            this.removeEmptyQualifiersSetFromMdr(propertySet, keyRoot, retrieval, QualifierPoint.PROPERTY);
        }

        @Override
        void removeQualifiersFromMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
            this.removeQualifiersFromSetInMdr(null, retrieval, this.getKey(type, point), qualifiers);
        }

        @Override
        Set<Object> mergeQualifiersFromMdr(ControllerContext context, QualifierType type, QualifierPoint point) {
            return super.mergeQualifiersFromMdr(context, this.getKey(this.typeToKeyRoot(type), point));
        }

        @Override
        public String getKey(QualifierType type, QualifierPoint point) {
            return this.getKey(this.typeToKeyRoot(type), point);
        }

        @Override
        String getKey(String className, QualifierPoint point) {
            if (point == null) {
                throw new IllegalArgumentException("Null point for required/optional qualifier");
            }
            switch (point) {
                case CONSTRUCTOR: {
                    return className + QualifiersMdrUtil.CONSTRUCTOR_SUFFIX;
                }
                case METHOD: {
                    return className + QualifiersMdrUtil.METHOD_SUFFIX;
                }
                case PROPERTY: {
                    return className + QualifiersMdrUtil.PROPERTY_SUFFIX;
                }
            }
            throw new IllegalArgumentException("Unknown point " + (Object)((Object)point));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuppliedMDRStrategy
    extends MDRStrategy {
        private SuppliedMDRStrategy() {
        }

        @Override
        void addQualifiersToSetInMdr(Set<RelatedClassMetaData> relateds, String keyRoot, MetaDataRetrieval retrieval) {
            if (!keyRoot.equals(SUPPLIED_QUALIFIER_KEY)) {
                throw new IllegalArgumentException("Wrong key " + keyRoot);
            }
            Set<Object> set = null;
            for (RelatedClassMetaData rcmd : relateds) {
                set = this.addQualifiersToSetInMdr(set, retrieval, keyRoot, rcmd.getEnabled().toArray());
            }
        }

        @Override
        void addQualifiersToMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
            if (type != QualifierType.SUPPLIED) {
                throw new IllegalArgumentException("Wrong type " + (Object)((Object)type));
            }
            if (point != null) {
                throw new IllegalArgumentException("Injection poing passed in for supplied qualifier");
            }
            this.addQualifiersToSetInMdr(null, retrieval, SUPPLIED_QUALIFIER_KEY, qualifiers);
        }

        @Override
        void removeQualifiersFromSetInMdr(Set<RelatedClassMetaData> relateds, String keyRoot, MetaDataRetrieval retrieval) {
            try {
                if (relateds == null || relateds.size() == 0) {
                    return;
                }
                if (!keyRoot.equals(keyRoot)) {
                    throw new IllegalArgumentException("Wrong key " + keyRoot);
                }
                Set<Object> set = this.getQualifiersSetInMdr(retrieval, keyRoot, false);
                if (set != null) {
                    for (RelatedClassMetaData rcmd : relateds) {
                        if (rcmd.getEnabled() == null || rcmd.getEnabled().size() <= 0) continue;
                        set.removeAll(rcmd.getEnabled());
                    }
                }
                this.removeEmptyQualifiersSetFromMdr(set, keyRoot, retrieval, null);
            }
            catch (Exception e) {
                log.warn((Object)"Error removing qualifiers", (Throwable)e);
            }
        }

        @Override
        void removeQualifiersFromMdrRetrieval(MetaDataRetrieval retrieval, QualifierType type, QualifierPoint point, Object ... qualifiers) {
            if (type != QualifierType.SUPPLIED) {
                throw new IllegalArgumentException("Wrong type " + (Object)((Object)type));
            }
            if (point != null) {
                throw new IllegalArgumentException("Injection poing passed in for supplied qualifier");
            }
            this.removeQualifiersFromSetInMdr(null, retrieval, SUPPLIED_QUALIFIER_KEY, qualifiers);
        }

        @Override
        Set<Object> mergeQualifiersFromMdr(ControllerContext context, QualifierType type, QualifierPoint point) {
            return super.mergeQualifiersFromMdr(context, this.typeToKeyRoot(type));
        }

        @Override
        public String getKey(QualifierType type, QualifierPoint point) {
            return this.typeToKeyRoot(type);
        }

        @Override
        String getKey(String className, QualifierPoint point) {
            return className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MDRStrategy {
        private MDRStrategy() {
        }

        abstract void addQualifiersToSetInMdr(Set<RelatedClassMetaData> var1, String var2, MetaDataRetrieval var3);

        abstract void addQualifiersToMdrRetrieval(MetaDataRetrieval var1, QualifierType var2, QualifierPoint var3, Object ... var4);

        abstract void removeQualifiersFromSetInMdr(Set<RelatedClassMetaData> var1, String var2, MetaDataRetrieval var3);

        abstract void removeQualifiersFromMdrRetrieval(MetaDataRetrieval var1, QualifierType var2, QualifierPoint var3, Object ... var4);

        abstract Set<Object> mergeQualifiersFromMdr(ControllerContext var1, QualifierType var2, QualifierPoint var3);

        abstract String getKey(String var1, QualifierPoint var2);

        abstract String getKey(QualifierType var1, QualifierPoint var2);

        Set<Object> addQualifiersToSetInMdr(Set<Object> qualifierSet, MetaDataRetrieval retrieval, String key, Object ... qualifiersToAdd) {
            if (qualifierSet == null) {
                qualifierSet = this.getQualifiersSetInMdr(retrieval, key, true);
            }
            for (Object qualifier : qualifiersToAdd) {
                qualifierSet.add(qualifier);
            }
            return qualifierSet;
        }

        void removeQualifiersFromSetInMdr(Set<Object> qualifierSet, MetaDataRetrieval retrieval, String key, Object ... qualifiersToRemove) {
            if (qualifierSet == null) {
                qualifierSet = this.getQualifiersSetInMdr(retrieval, key, false);
            }
            if (qualifierSet != null) {
                for (Object qualifier : qualifiersToRemove) {
                    qualifierSet.remove(qualifier);
                }
            }
            this.removeEmptyQualifiersSetFromMdr(qualifierSet, key, retrieval, null);
        }

        Set<Object> mergeQualifiersFromMdr(ControllerContext context, String key) {
            if (!(context instanceof KernelControllerContext)) {
                return null;
            }
            MutableMetaDataRepository repository = ((KernelControllerContext)context).getKernel().getMetaDataRepository().getMetaDataRepository();
            HashSet set = null;
            for (ScopeKey scope = context.getScopeInfo().getScope(); scope != null; scope = scope.getParent()) {
                HashSet entry;
                MetaData metaData = repository.getMetaData(scope);
                if (metaData == null || (entry = (HashSet)metaData.getMetaData(key, Set.class)) == null) continue;
                if (set == null) {
                    set = entry;
                    continue;
                }
                set = new HashSet(set);
                set.addAll(entry);
            }
            return set;
        }

        void removeEmptyQualifiersSetFromMdr(Set<Object> set, String keyRoot, MetaDataRetrieval retrieval, QualifierPoint point) {
            if (set != null && set.size() == 0) {
                ((MutableMetaData)retrieval).removeMetaData(this.getKey(keyRoot, point), Set.class);
            }
        }

        String typeToKeyRoot(QualifierType type) {
            switch (type) {
                case OPTIONAL: {
                    return OPTIONAL_QUALIFIER_KEY;
                }
                case REQUIRED: {
                    return REQUIRED_QUALIFIER_KEY;
                }
                case SUPPLIED: {
                    return SUPPLIED_QUALIFIER_KEY;
                }
            }
            throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Set<Object> getQualifiersSetInMdr(MetaDataRetrieval retrieval, String key, boolean create) {
            MetaDataItem item = retrieval.retrieveMetaData(key);
            Set set = null;
            if (item != null) return (Set)item.getValue();
            if (!create) return null;
            set = new ConcurrentSet(16, 0.75f, 2);
            ((MutableMetaData)retrieval).addMetaData(key, (Object)set, Set.class);
            return set;
        }
    }
}

