/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.registry.basic;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntryAlreadyRegisteredException;
import org.jboss.kernel.spi.registry.KernelRegistryEntryNotFoundException;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;

public class BasicKernelRegistryFactory
implements KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger(BasicKernelRegistryFactory.class);
    protected ConcurrentMap<Object, KernelRegistryEntry> entries = new ConcurrentHashMap<Object, KernelRegistryEntry>();

    public void registerEntry(Object name, KernelRegistryEntry entry) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (entry == null) {
            throw new IllegalArgumentException("Null entry");
        }
        boolean trace = log.isTraceEnabled();
        KernelRegistryEntry old = this.entries.putIfAbsent(name, entry);
        if (old != null) {
            throw new KernelRegistryEntryAlreadyRegisteredException("Already registered: " + name);
        }
        entry.setName(name);
        if (trace) {
            log.trace((Object)("Registered object: '" + entry + "' with name '" + name + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelRegistryEntry unregisterEntry(Object name) {
        KernelRegistryEntry entry;
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean trace = log.isTraceEnabled();
        ConcurrentMap<Object, KernelRegistryEntry> concurrentMap = this.entries;
        synchronized (concurrentMap) {
            entry = (KernelRegistryEntry)this.entries.remove(name);
            if (entry == null) {
                throw new KernelRegistryEntryNotFoundException("Not found: " + name);
            }
        }
        if (trace) {
            log.trace((Object)("Unregistered name: '" + name + "'"));
        }
        return entry;
    }

    public KernelRegistryEntry getEntry(Object name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        return (KernelRegistryEntry)this.entries.get(name);
    }
}

