/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import org.jboss.metadata.ejb.jboss.IORASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSASContextMetaData;
import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.jboss.metadata.ejb.jboss.IORTransportConfigMetaData;

public class IorSecurityConfigMetaData
implements Serializable {
    private static final long serialVersionUID = -3341898910508715334L;
    private TransportConfig transportConfig;
    private AsContext asContext;
    private SasContext sasContext;

    public IorSecurityConfigMetaData() {
        this.transportConfig = new TransportConfig();
        this.asContext = new AsContext();
        this.sasContext = new SasContext();
    }

    IorSecurityConfigMetaData(IORSecurityConfigMetaData securityConfigMetaData) {
        if (securityConfigMetaData == null) {
            throw new IllegalArgumentException("Null security config metadata");
        }
        this.transportConfig = new TransportConfig(securityConfigMetaData.getTransportConfig());
        this.asContext = new AsContext(securityConfigMetaData.getAsContext());
        this.sasContext = new SasContext(securityConfigMetaData.getSasContext());
    }

    public TransportConfig getTransportConfig() {
        return this.transportConfig;
    }

    public void setTransportConfig(TransportConfig config) {
        this.transportConfig = config;
    }

    public AsContext getAsContext() {
        return this.asContext;
    }

    public void setAsContext(AsContext context) {
        this.asContext = context;
    }

    public SasContext getSasContext() {
        return this.sasContext;
    }

    public void setSasContext(SasContext context) {
        this.sasContext = context;
    }

    public String toString() {
        return "[transport-config=" + this.transportConfig + ", as-context=" + this.asContext + ", sas-context=" + this.sasContext + "]";
    }

    public class SasContext {
        public static final String CALLER_PROPAGATION_NONE = "NONE";
        public static final String CALLER_PROPAGATION_SUPPORTED = "SUPPORTED";
        private final String callerPropagation;

        private SasContext() {
            this.callerPropagation = CALLER_PROPAGATION_NONE;
        }

        private SasContext(IORSASContextMetaData sasContext) {
            if (sasContext == null) {
                throw new IllegalArgumentException("Null sasContext");
            }
            this.callerPropagation = sasContext.getCallerPropagation();
        }

        public String getCallerPropagation() {
            return this.callerPropagation;
        }

        public boolean isCallerPropagationSupported() {
            return CALLER_PROPAGATION_SUPPORTED.equalsIgnoreCase(this.callerPropagation);
        }

        public String toString() {
            return "[caller-propagation=" + this.callerPropagation + "]";
        }
    }

    public class AsContext {
        public static final String AUTH_METHOD_USERNAME_PASSWORD = "USERNAME_PASSWORD";
        public static final String AUTH_METHOD_NONE = "NONE";
        private final String authMethod;
        private final String realm;
        private final boolean required;

        private AsContext() {
            this.authMethod = AUTH_METHOD_USERNAME_PASSWORD;
            this.realm = "default";
            this.required = false;
        }

        private AsContext(IORASContextMetaData asContext) {
            if (asContext == null) {
                throw new IllegalArgumentException("Null asContext");
            }
            this.authMethod = asContext.getAuthMethod();
            this.realm = asContext.getRealm();
            this.required = asContext.isRequired();
        }

        public String getAuthMethod() {
            return this.authMethod;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "[auth-method=" + this.authMethod + ", realm=" + this.realm + ", required=" + this.required + "]";
        }
    }

    public class TransportConfig {
        public static final String INTEGRITY_NONE = "NONE";
        public static final String INTEGRITY_SUPPORTED = "SUPPORTED";
        public static final String INTEGRITY_REQUIRED = "REQUIRED";
        public static final String CONFIDENTIALITY_NONE = "NONE";
        public static final String CONFIDENTIALITY_SUPPORTED = "SUPPORTED";
        public static final String CONFIDENTIALITY_REQUIRED = "REQUIRED";
        public static final String DETECT_MISORDERING_NONE = "NONE";
        public static final String DETECT_MISORDERING_SUPPORTED = "SUPPORTED";
        public static final String DETECT_MISORDERING_REQUIRED = "REQUIRED";
        public static final String DETECT_REPLAY_NONE = "NONE";
        public static final String DETECT_REPLAY_SUPPORTED = "SUPPORTED";
        public static final String DETECT_REPLAY_REQUIRED = "REQUIRED";
        public static final String ESTABLISH_TRUST_IN_TARGET_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_TARGET_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_NONE = "NONE";
        public static final String ESTABLISH_TRUST_IN_CLIENT_SUPPORTED = "SUPPORTED";
        public static final String ESTABLISH_TRUST_IN_CLIENT_REQUIRED = "REQUIRED";
        private final String integrity;
        private final String confidentiality;
        private final String detectMisordering;
        private final String detectReplay;
        private final String establishTrustInTarget;
        private final String establishTrustInClient;

        private TransportConfig() {
            this.integrity = "SUPPORTED";
            this.confidentiality = "SUPPORTED";
            this.establishTrustInTarget = "SUPPORTED";
            this.establishTrustInClient = "SUPPORTED";
            this.detectMisordering = "SUPPORTED";
            this.detectReplay = "SUPPORTED";
        }

        private TransportConfig(IORTransportConfigMetaData tranportConfig) {
            if (tranportConfig == null) {
                throw new IllegalArgumentException("Null transport config");
            }
            this.integrity = tranportConfig.getIntegrity();
            this.confidentiality = tranportConfig.getIntegrity();
            this.establishTrustInClient = tranportConfig.getEstablishTrustInClient();
            this.establishTrustInTarget = tranportConfig.getEstablishTrustInTarget();
            this.detectReplay = tranportConfig.getDetectReplay();
            this.detectMisordering = tranportConfig.getDetectMisordering();
        }

        public String getIntegrity() {
            return this.integrity;
        }

        public String getConfidentiality() {
            return this.confidentiality;
        }

        public String getDetectMisordering() {
            return this.detectMisordering;
        }

        public String getDetectReplay() {
            return this.detectReplay;
        }

        public String getEstablishTrustInTarget() {
            return this.establishTrustInTarget;
        }

        public boolean isEstablishTrustInTargetSupported() {
            return "SUPPORTED".equalsIgnoreCase(this.establishTrustInTarget);
        }

        public String getEstablishTrustInClient() {
            return this.establishTrustInClient;
        }

        public String toString() {
            return "[integrity=" + this.integrity + ", confidentiality=" + this.confidentiality + ", establish-trust-in-target=" + this.establishTrustInTarget + ", establish-trust-in-client=" + this.establishTrustInClient + ", detect-misordering=" + this.detectMisordering + ", detect-replay=" + this.detectReplay + "]";
        }
    }
}

