/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.jboss.jndipolicy.plugins;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.PackagingType;

public class BasicJndiBindingPolicy
implements DefaultJndiBindingPolicy {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(BasicJndiBindingPolicy.class);

    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        String baseJndiName = this.getBaseJndiName(summary);
        return baseJndiName + "/" + "localHome";
    }

    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        String baseJndiName = this.getBaseJndiName(summary);
        return baseJndiName + "/" + "local";
    }

    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        String baseJndiName = this.getBaseJndiName(summary);
        return baseJndiName + "/" + "home";
    }

    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        String baseJndiName = this.getBaseJndiName(summary);
        return baseJndiName + "/" + "remote";
    }

    public String getJndiName(EjbDeploymentSummary summary) {
        String baseJndiName = this.getBaseJndiName(summary);
        return baseJndiName;
    }

    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        String jndiName = null;
        if (KnownInterfaces.isKnownInterface(iface)) {
            iface = null;
        }
        String baseJndiName = this.getBaseJndiName(summary);
        if (ifaceType == KnownInterfaces.KnownInterfaceType.UNKNOWN) {
            jndiName = iface == null ? baseJndiName : baseJndiName + "/" + iface;
        } else {
            boolean is3x = summary.getBeanMD().getJBossMetaData().isEJB3x();
            if (is3x) {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: {
                        if (iface == null) {
                            jndiName = baseJndiName + "/" + ifaceType.toSuffix();
                            break;
                        }
                        jndiName = baseJndiName + "/" + ifaceType.toSuffix() + "-" + iface;
                        break;
                    }
                    case BUSINESS_REMOTE: 
                    case UNKNOWN: {
                        String setMappedName;
                        JBossEnterpriseBeanMetaData md = summary.getBeanMD();
                        String mappedName = null;
                        if (md.isSession()) {
                            mappedName = ((JBossSessionBeanMetaData)md).getJndiName();
                        }
                        if ((setMappedName = md.getMappedName()) != null && setMappedName.trim().length() > 0) {
                            mappedName = md.getMappedName();
                        }
                        if (mappedName != null && iface == null) {
                            jndiName = mappedName;
                            break;
                        }
                        if (iface == null) {
                            jndiName = baseJndiName + "/" + ifaceType.toSuffix();
                            break;
                        }
                        jndiName = baseJndiName + "/" + ifaceType.toSuffix() + "-" + iface;
                        break;
                    }
                    case LOCAL_HOME: {
                        jndiName = baseJndiName + "/" + ifaceType.toSuffix();
                        break;
                    }
                    case REMOTE_HOME: {
                        JBossSessionBeanMetaData smd;
                        String explicitHomeJndiName;
                        JBossEnterpriseBeanMetaData beanMd = summary.getBeanMD();
                        jndiName = beanMd.isSession() && (explicitHomeJndiName = (smd = (JBossSessionBeanMetaData)beanMd).getHomeJndiName()) != null && explicitHomeJndiName.length() > 0 ? explicitHomeJndiName : baseJndiName + "/" + ifaceType.toSuffix();
                    }
                }
            } else {
                switch (ifaceType) {
                    case BUSINESS_LOCAL: 
                    case LOCAL_HOME: {
                        jndiName = summary.getBeanMD().getLocalJndiName();
                        if (jndiName != null && jndiName.trim().length() > 0) {
                            return jndiName;
                        }
                        String ejbName = summary.getBeanMD().getEjbName();
                        jndiName = "local/" + ejbName + '@' + System.identityHashCode(ejbName);
                        break;
                    }
                    case BUSINESS_REMOTE: 
                    case REMOTE_HOME: {
                        JBossEnterpriseBeanMetaData md = summary.getBeanMD();
                        String mappedName = md.getMappedName();
                        if (mappedName == null || mappedName.length() == 0) {
                            if (md.isSession()) {
                                mappedName = ((JBossSessionBeanMetaData)md).getJndiName();
                            } else if (md.isEntity()) {
                                mappedName = ((JBossEntityBeanMetaData)md).getJndiName();
                            }
                        }
                        if ((jndiName = mappedName) != null && jndiName.trim().length() > 0) {
                            return jndiName;
                        }
                        jndiName = baseJndiName;
                    }
                }
            }
        }
        return jndiName;
    }

    private String getBaseJndiName(EjbDeploymentSummary summary) {
        String jndiName;
        StringBuffer baseName = new StringBuffer();
        JBossEnterpriseBeanMetaData md = summary.getBeanMD();
        assert (md != null) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " is not set for " + summary;
        if (md.isSession()) {
            assert (md instanceof JBossSessionBeanMetaData) : "Metadata reports as Session Bean but is not assignable to " + JBossSessionBeanMetaData.class.getName();
            JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)md;
            baseName.append(smd.getEjbName());
        } else if (md.isEntity() && (baseName == null || baseName.length() == 0) && (jndiName = ((JBossEntityBeanMetaData)summary.getBeanMD()).getJndiName()) != null && jndiName.length() > 0) {
            baseName.append(jndiName.trim());
        }
        if (baseName == null || baseName.length() == 0) {
            baseName.append(summary.getBeanMD().getEjbName());
        }
        boolean isEar = false;
        PackagingType packagingType = summary.getPackagingType();
        if (packagingType != null) {
            isEar = packagingType.equals((Object)PackagingType.EAR);
        }
        String deploymentScopeBaseName = summary.getDeploymentScopeBaseName();
        if (isEar && deploymentScopeBaseName != null && deploymentScopeBaseName.trim().length() > 0) {
            deploymentScopeBaseName = deploymentScopeBaseName.trim();
            String mappedName = summary.getBeanMD().getMappedName();
            if (md.isSession() && (mappedName == null || mappedName.trim().length() == 0)) {
                JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)md;
                mappedName = smd.getJndiName();
            }
            if (deploymentScopeBaseName.equals(mappedName)) {
                log.warn((Object)("The EAR name, which is used as a base, is equal to the mappedName/jndiName for EJB \"" + summary.getBeanMD().getEjbName() + "\", to avoid JNDI Naming Conflict appending a '_' to the base JNDI name. [JBMETA-83][JBMETA-86]"));
                deploymentScopeBaseName = deploymentScopeBaseName + "_";
            }
            baseName.insert(0, '/');
            baseName.insert(0, deploymentScopeBaseName);
        }
        return baseName.toString();
    }
}

