/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.spec;

import java.util.HashMap;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;

public class AnnotationMergedView {
    public static void merge(EjbJar3xMetaData merged, EjbJar3xMetaData xml, EjbJar3xMetaData annotation) {
        EnterpriseBeansMetaData enterpriseBeans = new EnterpriseBeansMetaData();
        AnnotationMergedView.merge(enterpriseBeans, xml.getEnterpriseBeans(), annotation.getEnterpriseBeans());
        merged.setEnterpriseBeans(enterpriseBeans);
        AssemblyDescriptorMetaData assemblyDescriptor = new AssemblyDescriptorMetaData();
        AnnotationMergedView.merge(assemblyDescriptor, xml.getAssemblyDescriptor(), annotation.getAssemblyDescriptor());
        merged.setAssemblyDescriptor(assemblyDescriptor);
        if (xml.getDescriptionGroup() != null) {
            merged.setDescriptionGroup(xml.getDescriptionGroup());
        }
        merged.setDTD(null, xml.getDtdPublicId(), xml.getDtdSystemId());
        if (xml.getEjbClientJar() != null) {
            merged.setEjbClientJar(xml.getEjbClientJar());
        }
        if (xml.getId() != null) {
            merged.setId(xml.getId());
        }
        if (xml.getRelationships() != null) {
            merged.setRelationships(xml.getRelationships());
        }
        if (xml.getVersion() != null) {
            merged.setVersion(xml.getVersion());
        }
        merged.setMetadataComplete(xml.isMetadataComplete());
        if (xml.getInterceptors() != null || annotation.getInterceptors() != null) {
            InterceptorsMetaData interceptors = new InterceptorsMetaData();
            interceptors.merge(xml.getInterceptors(), annotation.getInterceptors());
            merged.setInterceptors(interceptors);
        }
    }

    private static void merge(AssemblyDescriptorMetaData merged, AssemblyDescriptorMetaData xml, AssemblyDescriptorMetaData annotation) {
        merged.merge(xml, annotation);
    }

    private static void merge(EnterpriseBeansMetaData merged, EnterpriseBeansMetaData xml, EnterpriseBeansMetaData annotation) {
        HashMap<String, String> ejbClassToName = new HashMap<String, String>();
        if (xml != null) {
            if (xml.getId() != null) {
                merged.setId(xml.getId());
            }
            for (EnterpriseBeanMetaData bean : xml) {
                String className = bean.getEjbClass();
                if (className == null) continue;
                int dot = className.lastIndexOf(46);
                if (dot >= 0) {
                    className = className.substring(dot + 1);
                }
                ejbClassToName.put(className, bean.getEjbName());
            }
        }
        if (annotation != null) {
            for (EnterpriseBeanMetaData bean : annotation) {
                if (xml != null) {
                    String xmlEjbName;
                    String ejbName = bean.getEjbName();
                    EnterpriseBeanMetaData match = (EnterpriseBeanMetaData)xml.get(ejbName);
                    if (match != null || (xmlEjbName = (String)ejbClassToName.get(ejbName)) != null) continue;
                    merged.add(bean);
                    continue;
                }
                merged.add(bean);
            }
        }
        if (xml != null) {
            for (EnterpriseBeanMetaData bean : xml) {
                String className;
                String name;
                EnterpriseBeanMetaData annBean = null;
                if (annotation != null && (annBean = (EnterpriseBeanMetaData)annotation.get(name = bean.getEjbName())) == null && (className = bean.getEjbClass()) != null) {
                    int dot = className.lastIndexOf(46);
                    if (dot >= 0) {
                        className = className.substring(dot + 1);
                    }
                    annBean = (EnterpriseBeanMetaData)annotation.get(className);
                }
                EnterpriseBeanMetaData mbean = bean;
                if (annBean != null) {
                    mbean = EnterpriseBeanMetaData.newBean(bean);
                    mbean.merge(bean, annBean);
                }
                merged.add(mbean);
            }
        }
    }
}

