/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.jar.Manifest;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.FileEntryResource;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoaders;

final class FileResourceLoader
extends NativeLibraryResourceLoader
implements IterableResourceLoader {
    private final String rootName;
    private final Manifest manifest;
    private final CodeSource codeSource;

    FileResourceLoader(String rootName, File root) {
        super(root);
        URL rootUrl;
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (rootName == null) {
            throw new IllegalArgumentException("rootName is null");
        }
        this.rootName = rootName;
        File manifestFile = new File(root, "META-INF" + File.separatorChar + "MANIFEST.MF");
        this.manifest = FileResourceLoader.readManifestFile(manifestFile);
        try {
            rootUrl = root.getAbsoluteFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid root file specified", e);
        }
        this.codeSource = new CodeSource(rootUrl, (CodeSigner[])null);
    }

    private static Manifest readManifestFile(File manifestFile) {
        try {
            return new Manifest(new FileInputStream(manifestFile));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public ClassSpec getClassSpec(String fileName) throws IOException {
        File file = new File(this.getRoot(), fileName);
        if (!file.exists()) {
            return null;
        }
        long size = file.length();
        ClassSpec spec = new ClassSpec();
        spec.setCodeSource(this.codeSource);
        FileInputStream is = new FileInputStream(file);
        try {
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = ((InputStream)is).read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                ((InputStream)is).close();
                spec.setBytes(bytes);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw new IOException("Resource is too large to be a valid class file");
        }
        finally {
            FileResourceLoader.safeClose(is);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        return FileResourceLoader.getPackageSpec(name, this.manifest, this.getRoot().toURI().toURL());
    }

    @Override
    public Resource getResource(String name) {
        String canonPath = PathUtils.canonicalize(PathUtils.relativize(name));
        try {
            File file = new File(this.getRoot(), canonPath);
            if (!file.exists()) {
                return null;
            }
            return new FileEntryResource(canonPath, file, file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public Iterator<Resource> iterateResources(String startPath, boolean recursive) {
        String canonPath = PathUtils.canonicalize(PathUtils.relativize(startPath));
        File start = new File(this.getRoot(), canonPath);
        String[] children = start.list();
        if (children == null || children.length == 0) {
            return Collections.emptySet().iterator();
        }
        return new Itr(canonPath, children, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPaths() {
        ArrayList<String> index = new ArrayList<String>();
        File indexFile = new File(this.getRoot().getPath() + ".index");
        if (ResourceLoaders.USE_INDEXES && indexFile.exists()) {
            ArrayList<String> arrayList;
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(indexFile)));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    index.add(s.trim());
                }
                arrayList = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return arrayList;
        }
        index.add("");
        this.buildIndex(index, this.getRoot(), "");
        if (ResourceLoaders.WRITE_INDEXES) {
            boolean ok = false;
            try {
                FileOutputStream fos = new FileOutputStream(indexFile);
                try {
                    OutputStreamWriter osw = new OutputStreamWriter(fos);
                    try {
                        BufferedWriter writer = new BufferedWriter(osw);
                        try {
                            for (String name : index) {
                                writer.write(name);
                                writer.write(10);
                            }
                            writer.close();
                            osw.close();
                            fos.close();
                            ok = true;
                        }
                        finally {
                            FileResourceLoader.safeClose(writer);
                        }
                    }
                    finally {
                        FileResourceLoader.safeClose(osw);
                    }
                }
                finally {
                    FileResourceLoader.safeClose(fos);
                }
            }
            catch (IOException e) {
            }
            finally {
                if (!ok) {
                    indexFile.delete();
                }
            }
        }
        return index;
    }

    private void buildIndex(List<String> index, File root, String pathBase) {
        File[] files = root.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                index.add(pathBase + file.getName());
                this.buildIndex(index, file, pathBase + file.getName() + "/");
            }
        }
    }

    class Itr
    implements Iterator<Resource> {
        private final String base;
        private final String[] names;
        private final boolean recursive;
        private int i = 0;
        private Itr nested;
        private Resource next;

        Itr(String base, String[] names, boolean recursive) {
            assert (PathUtils.isRelative(base));
            assert (names != null && names.length > 0);
            this.base = base;
            this.names = names;
            this.recursive = recursive;
        }

        @Override
        public boolean hasNext() {
            String[] names = this.names;
            if (this.next != null) {
                return true;
            }
            String base = this.base;
            while (this.i < names.length) {
                String[] children;
                String current = names[this.i];
                String full = base.isEmpty() ? current : base + "/" + current;
                File file = new File(FileResourceLoader.this.getRoot(), full);
                if (this.recursive && this.nested == null && (children = file.list()) != null && children.length > 0) {
                    this.nested = new Itr(full, children, this.recursive);
                }
                if (this.nested != null) {
                    if (this.nested.hasNext()) {
                        this.next = this.nested.next();
                        return true;
                    }
                    this.nested = null;
                }
                ++this.i;
                if (!file.isFile()) continue;
                try {
                    this.next = new FileEntryResource(full, file, file.toURI().toURL());
                    return true;
                }
                catch (MalformedURLException ignored) {
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resource next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Resource resource = this.next;
                return resource;
            }
            finally {
                this.next = null;
            }
        }

        @Override
        public void remove() {
        }
    }
}

