/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.Objects;

final class ConnectionKey {
    private final String hostName;
    private final String protocol;
    private final String userInfo;
    private final int port;
    private final int hashCode;

    ConnectionKey(String hostName, String protocol, String userInfo, int port) {
        this.hostName = hostName;
        this.protocol = protocol;
        this.userInfo = userInfo;
        this.port = port;
        this.hashCode = ((hostName.hashCode() * 17 + protocol.hashCode()) * 17 + port) * 17 + Objects.hashCode(userInfo);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConnectionKey && this.equals((ConnectionKey)obj);
    }

    boolean equals(ConnectionKey other) {
        return other != null && this.hashCode == other.hashCode && this.hostName.equals(other.hostName) && this.protocol.equals(other.protocol) && Objects.equals(this.userInfo, other.userInfo);
    }

    public String toString() {
        return String.format("Connection key for \"%s:%s%s:%d\"", this.protocol, this.userInfo == null ? "" : this.userInfo + "@", this.hostName, this.port);
    }
}

