/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.net.SocketAddress;
import java.net.URI;
import java.util.Map;
import javax.security.sasl.SaslClientFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Sequence;

public final class ConnectionBuilder {
    private final URI uri;
    private boolean immediate;
    private SaslClientFactory saslClientFactory;
    private AuthenticationContext authenticationContext;
    private SocketAddress bindAddress;
    private String abstractType;
    private String abstractTypeAuthority;
    private final OptionMap.Builder optionMapBuilder = OptionMap.builder();

    ConnectionBuilder(URI uri) {
        this.uri = uri;
    }

    public ConnectionBuilder setImmediate(boolean immediate) {
        this.immediate = immediate;
        return this;
    }

    public ConnectionBuilder setSaslClientFactory(SaslClientFactory saslClientFactory) {
        Assert.checkNotNullParam((String)"saslClientFactory", (Object)saslClientFactory);
        this.saslClientFactory = saslClientFactory;
        return this;
    }

    public ConnectionBuilder setAuthenticationContext(AuthenticationContext authenticationContext) {
        Assert.checkNotNullParam((String)"authenticationContext", (Object)authenticationContext);
        this.authenticationContext = authenticationContext;
        return this;
    }

    public ConnectionBuilder setBindAddress(SocketAddress bindAddress) {
        Assert.checkNotNullParam((String)"bindAddress", (Object)bindAddress);
        this.bindAddress = bindAddress;
        return this;
    }

    public ConnectionBuilder setAbstractType(String abstractType) {
        Assert.checkNotNullParam((String)"abstractType", (Object)abstractType);
        this.abstractType = abstractType;
        return this;
    }

    public ConnectionBuilder setAbstractTypeAuthority(String abstractTypeAuthority) {
        Assert.checkNotNullParam((String)"abstractTypeAuthority", (Object)abstractTypeAuthority);
        this.abstractTypeAuthority = abstractTypeAuthority;
        return this;
    }

    public <T> ConnectionBuilder setOption(Option<T> key, T value) {
        this.optionMapBuilder.set(key, value);
        return this;
    }

    public ConnectionBuilder setOption(Option<Integer> key, int value) {
        this.optionMapBuilder.set(key, value);
        return this;
    }

    public ConnectionBuilder setSequenceOption(Option<Sequence<Integer>> key, int ... values) {
        this.optionMapBuilder.setSequence(key, values);
        return this;
    }

    public ConnectionBuilder setOption(Option<Long> key, long value) {
        this.optionMapBuilder.set(key, value);
        return this;
    }

    public ConnectionBuilder setSequenceOption(Option<Sequence<Long>> key, long ... values) {
        this.optionMapBuilder.setSequence(key, values);
        return this;
    }

    public ConnectionBuilder setOption(Option<Boolean> key, boolean value) {
        this.optionMapBuilder.set(key, value);
        return this;
    }

    public ConnectionBuilder setSequenceOption(Option<Sequence<Boolean>> key, boolean ... values) {
        this.optionMapBuilder.setSequence(key, values);
        return this;
    }

    @SafeVarargs
    public final <T> ConnectionBuilder setSequenceOption(Option<Sequence<T>> key, T ... values) {
        this.optionMapBuilder.setSequence(key, (Object[])values);
        return this;
    }

    public ConnectionBuilder addAllOptions(Map<?, ?> map) throws ClassCastException {
        this.optionMapBuilder.add(map);
        return this;
    }

    public ConnectionBuilder addAllOptions(OptionMap optionMap) {
        this.optionMapBuilder.addAll(optionMap);
        return this;
    }

    URI getUri() {
        return this.uri;
    }

    boolean isImmediate() {
        return this.immediate;
    }

    SaslClientFactory getSaslClientFactory() {
        return this.saslClientFactory;
    }

    AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    String getAbstractType() {
        return this.abstractType;
    }

    String getAbstractTypeAuthority() {
        return this.abstractTypeAuthority;
    }

    OptionMap getOptions() {
        return this.optionMapBuilder.getMap();
    }
}

