/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslClientFactory;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.ManagedConnection;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class FutureConnection {
    private final EndpointImpl endpoint;
    private final URI uri;
    private final AtomicReference<FutureResult<Connection>> futureConnectionRef = new AtomicReference();
    private final boolean immediate;
    private final OptionMap options;
    private final AuthenticationConfiguration configuration;
    private final SaslClientFactory clientFactory;
    private final SecurityFactory<SSLContext> sslContextFactory;
    private final SocketAddress bindAddress;

    FutureConnection(EndpointImpl endpoint, SocketAddress bindAddress, URI uri, boolean immediate, OptionMap options, AuthenticationConfiguration configuration, SaslClientFactory clientFactory, SecurityFactory<SSLContext> sslContextFactory) {
        this.endpoint = endpoint;
        this.bindAddress = bindAddress;
        this.uri = uri;
        this.immediate = immediate;
        this.options = options;
        this.configuration = configuration;
        this.clientFactory = clientFactory;
        this.sslContextFactory = sslContextFactory;
    }

    void reconnectAfterDelay() {
        this.endpoint.getXnioWorker().getIoThread().executeAfter(this::init, 30L, TimeUnit.SECONDS);
    }

    IoFuture<Connection> init() {
        return this.connect(null);
    }

    void splice(final FutureResult<Connection> futureResult, IoFuture<Connection> realFuture) {
        futureResult.addCancelHandler(realFuture);
        realFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<Connection>>(){

            public void handleCancelled(FutureResult<Connection> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<Connection> attachment) {
                attachment.setException(exception);
            }

            public void handleDone(Connection data, FutureResult<Connection> attachment) {
                attachment.setResult((Object)new ManagedConnection(data, FutureConnection.this, (FutureResult<Connection>)futureResult));
            }
        }, futureResult);
    }

    IoFuture<Connection> connect(FutureResult<Connection> orig) {
        IoFuture<Connection> realFuture;
        AtomicReference<FutureResult<Connection>> futureConnectionRef = this.futureConnectionRef;
        FutureResult<Connection> oldVal = futureConnectionRef.get();
        if (oldVal != orig) {
            return oldVal.getIoFuture();
        }
        final FutureResult futureResult = new FutureResult();
        while (!futureConnectionRef.compareAndSet(oldVal, (FutureResult<Connection>)futureResult)) {
            oldVal = futureConnectionRef.get();
            if (oldVal == orig) continue;
            return oldVal.getIoFuture();
        }
        try {
            realFuture = this.endpoint.connect(this.uri, this.bindAddress, this.options, this.configuration, this.clientFactory, this.sslContextFactory);
        }
        catch (IOException e) {
            realFuture = new IoFuture<Connection>(e);
        }
        this.splice((FutureResult<Connection>)futureResult, realFuture);
        IoFuture ioFuture = futureResult.getIoFuture();
        ioFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureConnection>(){

            public void handleCancelled(FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            public void handleFailed(IOException exception, FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            public void handleDone(Connection connection, FutureConnection attachment) {
                connection.addCloseHandler((closed, exception) -> {
                    FutureConnection.this.clearRef((FutureResult<Connection>)futureResult);
                    if (attachment.immediate) {
                        attachment.connect((FutureResult<Connection>)((FutureResult)attachment.futureConnectionRef.get()));
                    }
                });
            }
        }, (Object)this);
        return ioFuture;
    }

    void clearRef(FutureResult<Connection> futureResult) {
        this.futureConnectionRef.compareAndSet(futureResult, null);
    }

    public IoFuture<Connection> get() {
        return this.init();
    }

    boolean isConnected() {
        FutureResult<Connection> futureResult = this.futureConnectionRef.get();
        return futureResult != null && futureResult.getIoFuture().getStatus() == IoFuture.Status.DONE;
    }
}

