/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs;

import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClient4Engine;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientWebTarget;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ResteasyClient
implements Client {
    protected volatile ClientHttpEngine httpEngine;
    protected volatile ExecutorService asyncInvocationExecutor;
    protected ClientConfiguration configuration;

    public ResteasyClient() {
        this.configuration = new ClientConfiguration(ResteasyProviderFactory.getInstance());
    }

    public ResteasyClient(ResteasyProviderFactory providerFactory) {
        this.configuration = new ClientConfiguration(providerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHttpEngine httpEngine() {
        ClientHttpEngine result = this.httpEngine;
        if (result == null) {
            ResteasyClient resteasyClient = this;
            synchronized (resteasyClient) {
                result = this.httpEngine;
                if (result == null) {
                    this.httpEngine = result = new ApacheHttpClient4Engine(this.configuration());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService asyncInvocationExecutor() {
        ExecutorService result = this.asyncInvocationExecutor;
        if (result == null) {
            ResteasyClient resteasyClient = this;
            synchronized (resteasyClient) {
                result = this.asyncInvocationExecutor;
                if (result == null) {
                    this.asyncInvocationExecutor = result = Executors.newFixedThreadPool(10);
                }
            }
        }
        return result;
    }

    public ResteasyClient httpEngine(ClientHttpEngine httpEngine) {
        this.httpEngine = httpEngine;
        return this;
    }

    public ResteasyClient asyncInvocationExecutor(ExecutorService asyncInvocationExecutor) {
        this.asyncInvocationExecutor = asyncInvocationExecutor;
        return this;
    }

    public void close() {
        try {
            this.httpEngine.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public ResteasyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(URI uri) throws NullPointerException {
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public ResteasyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        return new ClientWebTarget(this, uriBuilder, this.configuration);
    }

    public ResteasyWebTarget target(Link link) throws NullPointerException {
        URI uri = link.getUri();
        return new ClientWebTarget(this, uri, this.configuration);
    }

    public Invocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        ResteasyWebTarget target = this.target(link);
        return target.request(new String[]{link.getType()});
    }
}

