/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.AbortedResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestContextImpl;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponseContextImpl;
import org.jboss.resteasy.core.interception.ClientWriterInterceptorContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.DelegatingOutputStream;
import org.jboss.resteasy.util.Types;

public class ClientInvocation
implements Invocation {
    protected ResteasyClient client;
    protected ClientRequestHeaders headers;
    protected String method;
    protected Object entity;
    protected Type entityGenericType;
    protected Class entityClass;
    protected Annotation[] entityAnnotations;
    protected ClientConfiguration configuration;
    protected URI uri;
    protected DelegatingOutputStream delegatingOutputStream = new DelegatingOutputStream();
    protected OutputStream entityStream = this.delegatingOutputStream;

    public ClientInvocation(ResteasyClient client, URI uri, ClientRequestHeaders headers, ClientConfiguration parent) {
        this.uri = uri;
        this.client = client;
        this.configuration = new ClientConfiguration(parent);
        this.headers = headers;
    }

    public ClientConfiguration getClientConfiguration() {
        return this.configuration;
    }

    public ResteasyClient getClient() {
        return this.client;
    }

    public DelegatingOutputStream getDelegatingOutputStream() {
        return this.delegatingOutputStream;
    }

    public void setDelegatingOutputStream(DelegatingOutputStream delegatingOutputStream) {
        this.delegatingOutputStream = delegatingOutputStream;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream entityStream) {
        this.entityStream = entityStream;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Annotation[] getEntityAnnotations() {
        return this.entityAnnotations;
    }

    public void setEntityAnnotations(Annotation[] entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(ClientRequestHeaders headers) {
        this.headers = headers;
    }

    public Map<String, Object> getMutableProperties() {
        return this.configuration.getMutableProperties();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Type getEntityGenericType() {
        return this.entityGenericType;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    public ClientRequestHeaders getHeaders() {
        return this.headers;
    }

    public void setEntity(Entity entity) {
        if (entity == null) {
            this.entity = null;
            this.entityAnnotations = null;
            this.entityClass = null;
            this.entityGenericType = null;
        } else {
            Object ent = entity.getEntity();
            this.setEntityObject(ent);
            Variant v = entity.getVariant();
            this.headers.setMediaType(v.getMediaType());
            this.headers.setLanguage(v.getLanguage());
            this.headers.header("Content-Encoding", v.getEncoding());
        }
    }

    public void setEntityObject(Object ent) {
        if (ent instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)ent;
            this.entityClass = genericEntity.getRawType();
            this.entityGenericType = genericEntity.getType();
            this.entity = genericEntity.getEntity();
        } else {
            this.entity = ent;
            this.entityClass = ent.getClass();
        }
    }

    public void writeRequestBody(OutputStream outputStream) throws IOException {
        if (this.entity == null) {
            return;
        }
        MessageBodyWriter writer = this.getWriter();
        WriterInterceptor[] interceptors = this.getWriterInterceptors();
        if (interceptors == null || interceptors.length == 0) {
            writer.writeTo(this.entity, this.entityClass, this.entityGenericType, this.entityAnnotations, this.headers.getMediaType(), this.headers.getHeaders(), outputStream);
        } else {
            ClientWriterInterceptorContext ctx = new ClientWriterInterceptorContext(interceptors, writer, this.entity, this.entityClass, this.entityGenericType, this.entityAnnotations, this.headers.getMediaType(), this.headers.getHeaders(), outputStream, this.getMutableProperties());
            ctx.proceed();
        }
    }

    public MessageBodyWriter getWriter() {
        MessageBodyWriter writer = this.configuration.getMessageBodyWriter(this.entityClass, this.entityGenericType, this.entityAnnotations, this.getHeaders().getMediaType());
        if (writer == null) {
            throw new ProcessingException("could not find writer for content-type " + this.getHeaders().getMediaType() + " type: " + this.entityClass.getName());
        }
        return writer;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.configuration.getWriterInterceptors(null, null);
    }

    public ClientRequestFilter[] getRequestFilters() {
        return this.configuration.getRequestFilters(null, null);
    }

    public ClientResponseFilter[] getResponseFilters() {
        return this.configuration.getResponseFilters(null, null);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invoke() {
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.configuration);
        try {
            ClientRequestContextImpl requestContext = new ClientRequestContextImpl(this);
            ClientRequestFilter[] requestFilters = this.getRequestFilters();
            if (requestFilters != null && requestFilters.length > 0) {
                for (ClientRequestFilter filter : requestFilters) {
                    try {
                        filter.filter((ClientRequestContext)requestContext);
                        if (requestContext.getAbortedWithResponse() == null) continue;
                        if (requestContext.getAbortedWithResponse() instanceof ClientResponse) {
                            Response response = requestContext.getAbortedWithResponse();
                            return response;
                        }
                        AbortedResponse abortedResponse = new AbortedResponse(this.configuration, requestContext.getAbortedWithResponse());
                        return abortedResponse;
                    }
                    catch (ProcessingException e) {
                        throw e;
                    }
                    catch (WebApplicationException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ProcessingException(e);
                    }
                }
            }
            ClientResponse response = this.client.httpEngine().invoke(this);
            response.setProperties(this.configuration.getMutableProperties());
            ClientResponseFilter[] responseFilters = this.getResponseFilters();
            if (requestFilters != null && requestFilters.length > 0) {
                ClientResponseContextImpl responseContext = new ClientResponseContextImpl(response);
                for (ClientResponseFilter filter : responseFilters) {
                    try {
                        filter.filter((ClientRequestContext)requestContext, (ClientResponseContext)responseContext);
                    }
                    catch (ResponseProcessingException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ResponseProcessingException((Response)response, e);
                    }
                }
            }
            ClientResponse clientResponse = response;
            return clientResponse;
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
        }
    }

    public <T> T invoke(Class<T> responseType) {
        Response response = this.invoke();
        return (T)response.readEntity(responseType);
    }

    public <T> T invoke(GenericType<T> responseType) {
        Response response = this.invoke();
        return (T)response.readEntity(responseType);
    }

    public Future<Response> submit() {
        return this.client.asyncInvocationExecutor().submit(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                return ClientInvocation.this.invoke();
            }
        });
    }

    public <T> Future<T> submit(Class<T> responseType) {
        final Future<Response> future = this.submit();
        final Class<T> type = responseType;
        return new Future<T>(){

            @Override
            public boolean cancel(boolean b) {
                return future.cancel(b);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                Response response = (Response)future.get();
                return response.readEntity(type);
            }

            @Override
            public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                Response response = (Response)future.get(l, timeUnit);
                return response.readEntity(type);
            }
        };
    }

    public <T> Future<T> submit(GenericType<T> responseType) {
        Future<Response> future = this.submit();
        return new TypeLiteralFuture(responseType, future);
    }

    public <T> Future<T> submit(InvocationCallback<T> callback) {
        Class<Response> type = Response.class;
        Type genericType = null;
        Type[] typeInfo = Types.getActualTypeArgumentsOfAnInterface(callback.getClass(), InvocationCallback.class);
        if (typeInfo != null) {
            type = Types.getRawType((Type)typeInfo[0]);
            genericType = typeInfo[0];
            if (type == null) {
                type = Response.class;
            }
        }
        final InvocationCallback<T> cb = callback;
        if (type.equals(Response.class)) {
            Future<Response> future = this.client.asyncInvocationExecutor().submit(new Callable<Response>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Response call() throws Exception {
                    Response res = null;
                    try {
                        res = ClientInvocation.this.invoke();
                    }
                    catch (Exception t) {
                        cb.failed((Throwable)t);
                        throw t;
                    }
                    try {
                        cb.completed((Object)res);
                        Response response = res;
                        return response;
                    }
                    finally {
                        res.close();
                    }
                }
            });
            return future;
        }
        final Class<Response> theType = type;
        final Type theGenericType = genericType;
        Future future = this.client.asyncInvocationExecutor().submit(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Response res = ClientInvocation.this.invoke();
                Object obj = null;
                try {
                    try {
                        GenericType gt = null;
                        gt = theGenericType != null ? new GenericType(theGenericType) : new GenericType((Type)theType);
                        obj = res.readEntity(gt);
                    }
                    catch (Exception ex) {
                        ResponseProcessingException rpe = new ResponseProcessingException(res, (Throwable)ex);
                        cb.failed((Throwable)rpe);
                        throw ex;
                    }
                    cb.completed(obj);
                    Object object = obj;
                    return object;
                }
                finally {
                    res.close();
                }
            }
        });
        return future;
    }

    public Invocation property(String name, Object value) {
        this.configuration.property(name, value);
        return this;
    }

    private static class TypeLiteralFuture<T>
    implements Future<T> {
        protected GenericType<T> type;
        protected Future<Response> future;

        private TypeLiteralFuture(GenericType<T> type, Future<Response> future) {
            this.type = type;
            this.future = future;
        }

        @Override
        public boolean cancel(boolean b) {
            return this.future.cancel(b);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            Response response = this.future.get();
            return (T)response.readEntity(this.type);
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            Response response = this.future.get(l, timeUnit);
            return (T)response.readEntity(this.type);
        }
    }
}

