/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.validator;

import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.text.SeamTextLexer;
import org.jboss.seam.text.SeamTextParser;

public class FormattedTextValidator
implements Validator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_OF_CONTEXT_CHARS_AFTER = 10;
    private static final int NUMBER_OF_CONTEXT_CHARS_BEFORE = 10;
    String firstError;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        block6: {
            this.firstError = null;
            if (value == null) {
                return;
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("Value is not a string: " + value);
            }
            String text = (String)value;
            StringReader r = new StringReader(text);
            SeamTextLexer lexer = new SeamTextLexer((Reader)r);
            SeamTextParser parser = new SeamTextParser((TokenStream)lexer);
            try {
                parser.startRule();
            }
            catch (TokenStreamException tse) {
                throw new RuntimeException(tse);
            }
            catch (RecognitionException re) {
                if (this.firstError != null) break block6;
                this.firstError = FormattedTextValidator.getErrorMessage(text, re);
            }
        }
        if (this.firstError != null) {
            throw new ValidatorException(new FacesMessage("Invalid markup: " + this.firstError));
        }
    }

    public static String getErrorMessage(String originalText, RecognitionException re) {
        int beginIndex = Math.max(re.getColumn() - 1 - 10, 0);
        int endIndex = Math.min(re.getColumn() + 10, originalText.length());
        String msg = re.getMessage() + " at '" + (beginIndex == 0 ? "" : "...") + originalText.substring(beginIndex, endIndex) + (endIndex == originalText.length() ? "" : "...") + "'";
        return msg.replace("\n", " ").replace("\r", " ").replace("\uffff", "[END OF TEXT]").replace("#{", "# {");
    }
}

