/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class LobSearchUtil {
    private static final int MOD = 37;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long position(StreamProvider pattern, long patternLength, StreamProvider target, long targetLength, long start, int bytesPerComparison) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        patternLength *= (long)bytesPerComparison;
        targetLength *= (long)bytesPerComparison;
        if (start < 1L) {
            Object[] params = new Object[]{new Long(start)};
            throw new MMSQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.2", params));
        }
        if ((start = (start - 1L) * (long)bytesPerComparison) + patternLength > targetLength) {
            return -1L;
        }
        try {
            InputStream patternStream = pattern.getBinaryStream();
            InputStream targetStream = target.getBinaryStream();
            InputStream laggingTargetStream = target.getBinaryStream();
            try {
                int patternHash = LobSearchUtil.computeStreamHash(patternStream, patternLength);
                int lastMod = 1;
                int i = 0;
                while ((long)i < patternLength) {
                    lastMod *= 37;
                    ++i;
                }
                targetStream.skip(start);
                laggingTargetStream.skip(start);
                long position = start + 1L;
                int streamHash = LobSearchUtil.computeStreamHash(targetStream, patternLength);
                do {
                    if ((position - 1L) % (long)bytesPerComparison == 0L && patternHash == streamHash && LobSearchUtil.validateMatch(pattern, target, position)) {
                        long l = (position - 1L) / (long)bytesPerComparison + 1L;
                        return l;
                    }
                    streamHash = 37 * streamHash + targetStream.read() - lastMod * laggingTargetStream.read();
                } while (++position + patternLength - 1L <= targetLength);
                long l = -1L;
                return l;
            }
            finally {
                if (patternStream != null) {
                    patternStream.close();
                }
                if (targetStream != null) {
                    targetStream.close();
                }
                if (laggingTargetStream != null) {
                    laggingTargetStream.close();
                }
            }
        }
        catch (IOException e) {
            throw MMSQLException.create(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean validateMatch(StreamProvider pattern, StreamProvider target, long position) throws IOException, SQLException {
        InputStream targetStream = target.getBinaryStream();
        InputStream patternStream = pattern.getBinaryStream();
        try {
            targetStream.skip(position - 1L);
            int value = 0;
            while ((value = patternStream.read()) != -1) {
                if (value == targetStream.read()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            targetStream.close();
            patternStream.close();
        }
        return true;
    }

    private static int computeStreamHash(InputStream is, long length) throws IOException {
        int result = 0;
        int i = 0;
        while ((long)i < length) {
            result = result * 37 + is.read();
            ++i;
        }
        return result;
    }

    public static interface StreamProvider {
        public InputStream getBinaryStream() throws SQLException;
    }
}

