/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.lob.LobChunkInputStream;
import com.metamatrix.common.lob.LobChunkProducer;
import com.metamatrix.common.types.BlobImpl;
import com.metamatrix.common.types.BlobType;
import com.metamatrix.dqp.client.impl.StreamingLobChunckProducer;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.LobSearchUtil;
import com.metamatrix.jdbc.MMSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MMBlob
implements Blob,
LobSearchUtil.StreamProvider {
    private final StreamingLobChunckProducer.Factory lobChunckFactory;
    private final BlobType blob;

    public static Blob newInstance(StreamingLobChunckProducer.Factory lobChunckFactory, BlobType blob) {
        Blob sourceBlob;
        if (!Boolean.getBoolean("FORCE_STREAMING") && (sourceBlob = blob.getSourceBlob()) != null) {
            return sourceBlob;
        }
        return new MMBlob(lobChunckFactory, blob);
    }

    public MMBlob(StreamingLobChunckProducer.Factory lobChunckFactory, BlobType blob) {
        this.lobChunckFactory = lobChunckFactory;
        this.blob = blob;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new LobChunkInputStream((LobChunkProducer)this.lobChunckFactory.getLobChunkProducer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new MMSQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
        }
        if (pos > this.length()) {
            return null;
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new MMSQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.3", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        byte[] dataCopy = new byte[length];
        InputStream in = this.getBinaryStream();
        try {
            try {
                in.skip(pos);
                in.read(dataCopy);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw MMSQLException.create(e);
        }
        return dataCopy;
    }

    @Override
    public long length() throws SQLException {
        return this.blob.length();
    }

    @Override
    public long position(final Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return LobSearchUtil.position(new LobSearchUtil.StreamProvider(){

            @Override
            public InputStream getBinaryStream() throws SQLException {
                return pattern.getBinaryStream();
            }
        }, pattern.length(), this, this.length(), start, 1);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return this.position((Blob)new BlobImpl(pattern), start);
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long arg0, byte[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long arg0, byte[] arg1, int arg2, int arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

