/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.api.MMURL;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.jdbc.BaseDataSource;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMDriver;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.util.MMJDBCURL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class MMDataSource
extends BaseDataSource {
    private int portNumber;
    private String serverName;
    private String credentials;
    private boolean secure = false;
    private String alternateServers;
    private String autoFailover;
    private String discoveryStrategy;

    @Override
    protected Properties buildProperties(String userName, String password) {
        Properties props = super.buildProperties(userName, password);
        props.setProperty("serverURL", this.buildServerURL());
        if (this.getAutoFailover() != null) {
            props.setProperty("autoFailover", this.getAutoFailover());
        }
        if (this.getCredentials() != null) {
            props.setProperty("credentials", this.getCredentials());
        }
        if (this.getDiscoveryStrategy() != null) {
            props.setProperty("discoveryStategy", this.getDiscoveryStrategy());
        }
        return props;
    }

    protected String buildServerURL() {
        if (this.alternateServers == null) {
            return new MMURL(this.serverName, this.portNumber, this.secure).getAppServerURL();
        }
        String serverURL = "";
        serverURL = "" + (this.secure ? "mms://" : "mm://");
        serverURL = serverURL + "" + this.serverName;
        if (this.portNumber != 0) {
            serverURL = serverURL + ":" + this.portNumber;
        }
        if (this.alternateServers.length() > 0) {
            String[] as = this.alternateServers.split(",");
            for (int i = 0; i < as.length; ++i) {
                String[] server = as[i].split(":");
                if (server.length <= 0) continue;
                serverURL = serverURL + "," + server[0];
                serverURL = server.length > 1 ? serverURL + ":" + server[1] : serverURL + ":" + this.portNumber;
            }
        }
        return new MMURL(serverURL).getAppServerURL();
    }

    protected String buildURL() {
        return new MMJDBCURL(this.getDatabaseName(), this.buildServerURL(), this.buildProperties(this.getUser(), this.getPassword())).getJDBCURL();
    }

    @Override
    protected void validateProperties(String userName, String password) throws SQLException {
        super.validateProperties(userName, password);
        String reason = MMDataSource.reasonWhyInvalidPortNumber(this.portNumber);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidServerName(this.serverName);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
        reason = MMDataSource.reasonWhyInvalidAlternateServers(this.alternateServers);
        if (reason != null) {
            throw this.createConnectionError(reason);
        }
    }

    private MMSQLException createConnectionError(String reason) {
        String msg = JDBCPlugin.Util.getString("MMDataSource.Err_connecting", new Object[]{reason});
        return new MMSQLException(msg);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String userName, String password) throws SQLException {
        try {
            this.validateProperties(userName, password);
            Properties props = this.buildProperties(userName, password);
            MMDriver driver = new MMDriver();
            return driver.createMMConnection(this.buildURL(), props);
        }
        catch (MetaMatrixCoreException e) {
            throw MMSQLException.create(e, e.getMessage());
        }
    }

    public String toString() {
        return this.buildURL().substring(16);
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getAlternateServers() {
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            return null;
        }
        return this.alternateServers;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setAlternateServers(String servers) {
        this.alternateServers = servers;
        if (this.alternateServers != null && this.alternateServers.length() < 1) {
            this.alternateServers = null;
        }
    }

    public static String reasonWhyInvalidPortNumber(int portNumber) {
        if (portNumber == 0) {
            return null;
        }
        if (portNumber < 1) {
            return JDBCPlugin.Util.getString("MMDataSource.Port_number_must_be_positive");
        }
        return null;
    }

    public static String reasonWhyInvalidServerName(String serverName) {
        if (serverName == null || serverName.trim().length() == 0) {
            return JDBCPlugin.Util.getString("MMDataSource.Server_name_required");
        }
        return null;
    }

    public static String reasonWhyInvalidSocketsPerVM(String socketsPerVM) {
        if (socketsPerVM != null) {
            int value = -1;
            try {
                value = Integer.parseInt(socketsPerVM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value <= 0) {
                return JDBCPlugin.Util.getString("MMDataSource.Sockets_per_vm_invalid");
            }
        }
        return null;
    }

    public static String reasonWhyInvalidStickyConnections(String stickyConnections) {
        if (stickyConnections != null && !stickyConnections.equalsIgnoreCase("true") && !stickyConnections.equalsIgnoreCase("false")) {
            return JDBCPlugin.Util.getString("MMDataSource.Sticky_connections_invalid");
        }
        return null;
    }

    public static String reasonWhyInvalidAlternateServers(String alternateServers) {
        if (alternateServers == null || alternateServers.trim().length() < 1) {
            return null;
        }
        String[] as = alternateServers.split(",");
        String sReason = null;
        String reason = "";
        int reasonCount = 0;
        String newline = System.getProperty("line.separator");
        for (int i = 0; i < as.length; ++i) {
            String[] server = as[i].split(":");
            if (server.length < 1 || server.length > 2) {
                return JDBCPlugin.Util.getString("MMDataSource.Alternate_Servers_format");
            }
            sReason = MMDataSource.reasonWhyInvalidServerName(server[0]);
            if (sReason != null) {
                reason = reason + (reason.length() > 0 ? newline : "") + sReason;
                ++reasonCount;
                sReason = null;
            }
            if (server.length <= 1) continue;
            int port = 0;
            try {
                port = Integer.parseInt(server[1]);
            }
            catch (NumberFormatException e) {
                reason = reason + (reason.length() > 0 ? newline : "") + JDBCPlugin.Util.getString("MMDataSource.serverPort_must_be_a_number");
                ++reasonCount;
            }
            sReason = MMDataSource.reasonWhyInvalidPortNumber(port);
            if (sReason == null) continue;
            reason = reason + (reason.length() > 0 ? newline : "") + sReason;
            ++reasonCount;
            sReason = null;
        }
        if (reasonCount < 1) {
            return null;
        }
        return JDBCPlugin.Util.getString("MMDataSource.alternateServer_is_invalid", new Object[]{String.valueOf(reasonCount), reason});
    }

    public String getAutoFailover() {
        return this.autoFailover;
    }

    public void setAutoFailover(String autoFailover) {
        this.autoFailover = autoFailover;
    }

    public String getDiscoveryStrategy() {
        return this.discoveryStrategy;
    }

    public void setDiscoveryStrategy(String discoveryStrategy) {
        this.discoveryStrategy = discoveryStrategy;
    }
}

