/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.query.ProcedureErrorInstructionException;
import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.jdbc.api.SQLException;
import com.metamatrix.jdbc.api.SQLStates;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class MMSQLException
extends java.sql.SQLException
implements SQLException {
    public MMSQLException() {
    }

    public static MMSQLException create(Throwable exception) {
        if (exception instanceof MMSQLException) {
            return (MMSQLException)exception;
        }
        return MMSQLException.create(exception, exception.getMessage());
    }

    public static MMSQLException create(Throwable exception, String message) {
        message = MMSQLException.getMessage(exception, message);
        Throwable origException = exception;
        if (exception instanceof MMSQLException && message.equals(exception.getMessage())) {
            return (MMSQLException)exception;
        }
        if (exception instanceof java.sql.SQLException) {
            return new MMSQLException((java.sql.SQLException)exception, message, true);
        }
        String sqlState = "38000";
        exception = MMSQLException.findRootException(exception);
        sqlState = MMSQLException.determineSQLState(exception, sqlState);
        return new MMSQLException(message, origException, sqlState);
    }

    private static String determineSQLState(Throwable exception, String sqlState) {
        if (exception instanceof InvalidSessionException) {
            sqlState = "08S01";
        } else if (exception instanceof LogonException) {
            sqlState = "28000";
        } else if (exception instanceof ProcedureErrorInstructionException) {
            sqlState = "50001";
        } else if (exception instanceof MetaMatrixProcessingException) {
            sqlState = "50000";
        } else if (exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof MalformedURLException || exception instanceof NoRouteToHostException || exception instanceof ConnectionException) {
            sqlState = "08001";
        } else if (exception instanceof IOException) {
            sqlState = "08S01";
        } else if (exception instanceof MetaMatrixCoreException) {
            if (exception instanceof CommunicationException) {
                sqlState = "08S01";
            }
            Throwable originalException = exception;
            exception = originalException.getCause();
            if ((exception = MMSQLException.findRootException(exception)) instanceof CommunicationException) {
                sqlState = "50000";
                exception = exception.getCause();
            }
            if (exception != null && exception != originalException) {
                sqlState = MMSQLException.determineSQLState(exception, sqlState);
            }
        }
        return sqlState;
    }

    private static Throwable findRootException(Throwable exception) {
        if (exception instanceof MetaMatrixRuntimeException) {
            while (exception.getCause() != exception && exception.getCause() != null) {
                exception = exception.getCause();
            }
            if (exception instanceof MetaMatrixRuntimeException) {
                MetaMatrixRuntimeException runtimeException = (MetaMatrixRuntimeException)exception;
                while (runtimeException.getChild() != exception && runtimeException.getChild() != null) {
                    if (runtimeException.getChild() instanceof MetaMatrixRuntimeException) {
                        runtimeException = (MetaMatrixRuntimeException)runtimeException.getChild();
                        continue;
                    }
                    exception = runtimeException.getChild();
                    break;
                }
            }
        }
        return exception;
    }

    private static String getMessage(Throwable exception, String message) {
        if (message == null && (message = exception.getMessage()) == null) {
            message = exception.getClass().getName();
        }
        return message;
    }

    private MMSQLException(String reason, Throwable ex, String sqlState) {
        super(reason, sqlState);
        this.initCause(ex);
    }

    private MMSQLException(java.sql.SQLException ex, String message, boolean addChildren) {
        super(message, ex.getSQLState() == null ? "38000" : ex.getSQLState(), ex.getErrorCode());
        if (addChildren) {
            for (java.sql.SQLException childException = ex; childException != null; childException = childException.getNextException()) {
                if (childException instanceof MMSQLException) {
                    super.setNextException(ex);
                    break;
                }
                super.setNextException(new MMSQLException(childException, MMSQLException.getMessage(childException, null), false));
            }
        }
    }

    MMSQLException(String reason) {
        super(reason, "38000");
    }

    @Override
    public Throwable getCause() {
        if (this.getNextException() != null) {
            return this.getNextException();
        }
        return super.getCause();
    }

    @Override
    public boolean isSystemErrorState() {
        return SQLStates.isSystemErrorState(this.getSQLState());
    }

    @Override
    public boolean isUsageErrorState() {
        return SQLStates.isUsageErrorState(this.getSQLState());
    }
}

