/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class MMJDBCURL {
    private static final String UTF_8 = "UTF-8";
    private static final String JDBC_PROTOCOL = "jdbc:metamatrix:";
    private static final String[] KNOWN_PROPERTIES = new String[]{"ApplicationName", "VirtualDatabaseName", "version", "VirtualDatabaseVersion", "user", "password", "txnAutoWrap", "partialResultsMode", "resultSetCacheMode", "allowDoubleQuotedVariable", "sqlOptions", "fetchSize", "XMLFormat", "XMLValidation", "disableLocalTxn", "clientToken", "credentials", "autoFailover", "discoveryStategy"};
    private String vdbName;
    private String connectionURL;
    private Properties properties = new Properties();
    private String urlString;

    public MMJDBCURL(String jdbcURL) {
        this.parseURL(jdbcURL);
    }

    public MMJDBCURL(String vdbName, String connectionURL, Properties props) {
        if (vdbName == null || vdbName.trim().length() == 0 || connectionURL == null || connectionURL.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.vdbName = vdbName;
        this.connectionURL = connectionURL;
        if (props != null) {
            MMJDBCURL.normalizeProperties(props, this.properties);
        }
    }

    public String getVDBName() {
        return this.vdbName;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public Properties getProperties() {
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)this.properties);
        return newProps;
    }

    private void parseURL(String jdbcURL) {
        if (jdbcURL == null) {
            throw new IllegalArgumentException();
        }
        if ((jdbcURL = jdbcURL.trim()).length() == 0) {
            throw new IllegalArgumentException();
        }
        int delimiter = jdbcURL.indexOf(64);
        if (delimiter == -1) {
            int fsc = jdbcURL.indexOf(59);
            if (fsc == -1) {
                this.parseJDBCProtocol(jdbcURL);
            } else {
                this.parseJDBCProtocol(jdbcURL.substring(0, fsc));
                MMJDBCURL.parseConnectionProperties(jdbcURL.substring(fsc + 1), this.properties);
            }
        } else {
            String[] urlParts = jdbcURL.split("@", 2);
            if (urlParts.length != 2) {
                throw new IllegalArgumentException();
            }
            this.parseJDBCProtocol(urlParts[0]);
            this.parseConnectionPart(urlParts[1]);
        }
    }

    private void parseJDBCProtocol(String protocol) {
        if (!protocol.startsWith(JDBC_PROTOCOL)) {
            throw new IllegalArgumentException();
        }
        if (protocol.length() == JDBC_PROTOCOL.length()) {
            throw new IllegalArgumentException();
        }
        this.vdbName = protocol.substring(JDBC_PROTOCOL.length());
    }

    private void parseConnectionPart(String connectionInfo) {
        String[] connectionParts = connectionInfo.split(";");
        if (connectionParts.length == 0 || connectionParts[0].trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.connectionURL = connectionParts[0].trim();
        if (connectionParts.length > 1) {
            for (int i = 1; i < connectionParts.length; ++i) {
                MMJDBCURL.parseConnectionProperty(connectionParts[i], this.properties);
            }
        }
    }

    public static void parseConnectionProperties(String connectionInfo, Properties p) {
        String[] connectionParts = connectionInfo.split(";");
        if (connectionParts.length != 0) {
            for (int i = 0; i < connectionParts.length; ++i) {
                MMJDBCURL.parseConnectionProperty(connectionParts[i], p);
            }
        }
    }

    static void parseConnectionProperty(String connectionProperty, Properties p) {
        if (connectionProperty.length() == 0) {
            return;
        }
        if (connectionProperty.length() < 3) {
            throw new IllegalArgumentException();
        }
        int firstEquals = connectionProperty.indexOf(61);
        if (firstEquals < 1) {
            throw new IllegalArgumentException();
        }
        String key = connectionProperty.substring(0, firstEquals).trim();
        String value = connectionProperty.substring(firstEquals + 1).trim();
        if (value.indexOf(61) >= 0) {
            throw new IllegalArgumentException();
        }
        MMJDBCURL.addNormalizedProperty(key, MMJDBCURL.getValidValue(value), p);
    }

    public String getJDBCURL() {
        if (this.urlString == null) {
            StringBuffer buf = new StringBuffer(JDBC_PROTOCOL).append(this.vdbName).append('@').append(this.connectionURL);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                buf.append(';').append(entry.getKey()).append('=').append(entry.getValue());
            }
            this.urlString = buf.toString();
        }
        return this.urlString;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getUserName() {
        return this.properties.getProperty("user");
    }

    public String getPassword() {
        return this.properties.getProperty("password");
    }

    public String getVDBVersion() {
        if (this.properties.contains("VirtualDatabaseVersion")) {
            return this.properties.getProperty("VirtualDatabaseVersion");
        }
        return this.properties.getProperty("version");
    }

    public String getTransactionAutowrapMode() {
        return this.properties.getProperty("txnAutoWrap");
    }

    public String getPartialResultsMode() {
        return this.properties.getProperty("partialResultsMode");
    }

    public String getResultSetCacheMode() {
        return this.properties.getProperty("resultSetCacheMode");
    }

    public String getAllowDoubleQuotedVariables() {
        return this.properties.getProperty("allowDoubleQuotedVariable");
    }

    public String getSQLOptions() {
        return this.properties.getProperty("sqlOptions");
    }

    public String getFetchSize() {
        return this.properties.getProperty("fetchSize");
    }

    public String getXMLFormat() {
        return this.properties.getProperty("XMLFormat");
    }

    public String getXMLValidation() {
        return this.properties.getProperty("XMLValidation");
    }

    public String getTransparentFailover() {
        return this.properties.getProperty("autoFailover");
    }

    public String getDisableLocalTransactions() {
        return this.properties.getProperty("disableLocalTxn");
    }

    public String toString() {
        return this.getJDBCURL();
    }

    private static void normalizeProperties(Properties source, Properties target) {
        Enumeration<?> e = source.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            MMJDBCURL.addNormalizedProperty(key, source.get(key), target);
        }
    }

    private static void addNormalizedProperty(String key, Object value, Properties target) {
        String validKey = MMJDBCURL.getValidKey(key);
        target.put(validKey, value);
    }

    private static String getValidKey(String key) {
        for (int i = 0; i < KNOWN_PROPERTIES.length; ++i) {
            if (!key.equalsIgnoreCase(KNOWN_PROPERTIES[i])) continue;
            return KNOWN_PROPERTIES[i];
        }
        return key;
    }

    private static Object getValidValue(Object value) {
        if (value instanceof String) {
            try {
                return URLDecoder.decode((String)value, UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return value;
    }

    public static Properties normalizeProperties(Properties props) {
        MMJDBCURL.normalizeProperties(props, props);
        return props;
    }
}

