/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.teiid.logging.LogManager;

public class ThreadCpuTimer {
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private int totalTime = -1;
    private long lastTime = -1L;
    private boolean active = threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled() && LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5);

    public void start() {
        if (!this.active) {
            return;
        }
        try {
            this.lastTime = threadMXBean.getCurrentThreadCpuTime();
        }
        catch (UnsupportedOperationException e) {
            this.inactivate();
        }
    }

    private void inactivate() {
        this.active = false;
        this.lastTime = -1L;
        this.totalTime = -1;
    }

    public long stop() {
        if (!this.active) {
            return -1L;
        }
        if (this.lastTime != -1L) {
            try {
                long time = threadMXBean.getCurrentThreadCpuTime();
                if (time != -1L) {
                    if (this.totalTime == -1) {
                        this.totalTime = 0;
                    }
                    this.totalTime = (int)((long)this.totalTime + (time - this.lastTime));
                } else {
                    this.inactivate();
                }
            }
            catch (UnsupportedOperationException e) {
                this.inactivate();
            }
        }
        this.lastTime = -1L;
        return this.totalTime;
    }
}

