/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.dqp.internal.process.SchemaChildRecordTable;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.symbol.ElementSymbol;

class FunctionSystemTable
extends SchemaChildRecordTable<FunctionMethod> {
    public FunctionSystemTable(int schemaPkColumnIndex, int tablePkColumnIndex, List<ElementSymbol> columns) {
        super(schemaPkColumnIndex, tablePkColumnIndex, columns);
    }

    @Override
    protected NavigableMap<String, FunctionMethod> getChildren(Schema s, TransformationMetadata metadata) {
        if (s.getName().equals("SYS")) {
            FunctionLibrary library = metadata.getFunctionLibrary();
            FunctionTree tree = library.getSystemFunctions();
            FunctionTree[] userFuncs = library.getUserFunctions();
            TreeMap<String, FunctionMethod> functions = new TreeMap<String, FunctionMethod>(String.CASE_INSENSITIVE_ORDER);
            for (FunctionTree userFunc : userFuncs) {
                if (!userFunc.getSchemaName().equals("SYS")) continue;
                functions.putAll(userFunc.getFunctionsByUuid());
            }
            functions.putAll(tree.getFunctionsByUuid());
            return functions;
        }
        return s.getFunctions();
    }
}

