/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.resource.spi.work.Work;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.dqp.internal.process.ByteLobChunkStream;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class LobWorkItem
implements Work {
    private RequestWorkItem parent;
    private int chunkSize;
    private String streamId;
    private ByteLobChunkStream stream;
    private int streamRequestId;
    private ResultsReceiver<LobChunk> resultsReceiver;

    public LobWorkItem(RequestWorkItem parent, DQPCore dqpCore, String streamId, int streamRequestId) {
        this.chunkSize = dqpCore.getChunkSize();
        this.streamId = streamId;
        this.parent = parent;
        this.streamRequestId = streamRequestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LobChunk chunk = null;
        Throwable ex = null;
        boolean shouldClose = false;
        try {
            if (this.stream == null) {
                this.stream = this.createLobStream(this.streamId);
            }
            chunk = this.stream.getNextChunk();
            this.parent.dataBytes.addAndGet(chunk.getBytes().length);
            shouldClose = chunk.isLast();
        }
        catch (TeiidComponentException e) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30027, new Object[0]));
            ex = e;
        }
        catch (IOException | SQLException e) {
            ex = new TeiidProcessingException((Throwable)e);
        }
        LobWorkItem lobWorkItem = this;
        synchronized (lobWorkItem) {
            if (ex != null) {
                this.resultsReceiver.exceptionOccurred(ex);
                shouldClose = true;
            } else {
                this.resultsReceiver.receiveResults((Object)chunk);
            }
            this.resultsReceiver = null;
        }
        if (shouldClose) {
            this.close();
        }
    }

    void close() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException e) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30027, new Object[0]));
        }
        this.parent.removeLobStream(this.streamRequestId);
    }

    private ByteLobChunkStream createLobStream(String referenceStreamId) throws TeiidComponentException, SQLException {
        Streamable<?> streamable = this.parent.resultsBuffer.getLobReference(referenceStreamId);
        if (streamable instanceof XMLType) {
            XMLType xml = (XMLType)streamable;
            return new ByteLobChunkStream(xml.getBinaryStream(), this.chunkSize);
        }
        if (streamable instanceof ClobType) {
            ClobType clob = (ClobType)streamable;
            return new ByteLobChunkStream((InputStream)new ReaderInputStream(clob.getCharacterStream(), Charset.forName("UTF-8")), this.chunkSize);
        }
        BlobType blob = (BlobType)streamable;
        return new ByteLobChunkStream(blob.getBinaryStream(), this.chunkSize);
    }

    synchronized void setResultsReceiver(ResultsReceiver<LobChunk> resultsReceiver) {
        Assertion.isNull(this.resultsReceiver, (String)"Cannot request results with a pending request");
        this.resultsReceiver = resultsReceiver;
    }

    public void release() {
    }
}

