/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.HashMap;
import java.util.Map;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingInterceptor;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;

public class InterceptingVisitor
extends MappingVisitor {
    MappingInterceptor interceptor;
    HashMap context = new HashMap();

    public InterceptingVisitor(MappingInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    @Override
    public void visit(MappingAllNode all) {
        this.interceptor.start(all, (Map)this.context);
        this.walkChildNodes(all);
        this.interceptor.end(all, (Map)this.context);
    }

    @Override
    public void visit(MappingAttribute attribute) {
        this.interceptor.start(attribute, (Map)this.context);
        this.interceptor.end(attribute, (Map)this.context);
    }

    @Override
    public void visit(MappingChoiceNode choice) {
        this.interceptor.start(choice, (Map)this.context);
        this.walkChildNodes(choice);
        this.interceptor.end(choice, (Map)this.context);
    }

    @Override
    public void visit(MappingCommentNode comment) {
        this.interceptor.start(comment, (Map)this.context);
        this.interceptor.end(comment, (Map)this.context);
    }

    @Override
    public void visit(MappingCriteriaNode node) {
        this.interceptor.start(node, (Map)this.context);
        this.walkChildNodes(node);
        this.interceptor.end(node, (Map)this.context);
    }

    @Override
    public void visit(MappingDocument doc) {
        this.interceptor.start(doc, (Map)this.context);
        doc.getRootNode().acceptVisitor(this);
        this.interceptor.end(doc, (Map)this.context);
    }

    @Override
    public void visit(MappingElement element) {
        this.interceptor.start(element, (Map)this.context);
        this.walkAttributes(element);
        this.walkChildNodes(element);
        this.interceptor.end(element, (Map)this.context);
    }

    @Override
    public void visit(MappingRecursiveElement element) {
        this.interceptor.start(element, (Map)this.context);
        this.interceptor.end(element, (Map)this.context);
    }

    @Override
    public void visit(MappingSequenceNode sequence) {
        this.interceptor.start(sequence, (Map)this.context);
        this.walkChildNodes(sequence);
        this.interceptor.end(sequence, (Map)this.context);
    }

    @Override
    public void visit(MappingSourceNode node) {
        this.interceptor.start(node, (Map)this.context);
        this.walkChildNodes(node);
        this.interceptor.end(node, (Map)this.context);
    }
}

