/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.teiid.query.mapping.xml.InterceptingVisitor;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingCriteriaNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingInterceptor;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.ResultSetInfo;
import org.teiid.query.optimizer.xml.TagBuilderVisitor;
import org.teiid.query.optimizer.xml.XMLPlannerEnvironment;
import org.teiid.query.processor.xml.AbortProcessingInstruction;
import org.teiid.query.processor.xml.AddNodeInstruction;
import org.teiid.query.processor.xml.BlockInstruction;
import org.teiid.query.processor.xml.CriteriaCondition;
import org.teiid.query.processor.xml.DefaultCondition;
import org.teiid.query.processor.xml.EndBlockInstruction;
import org.teiid.query.processor.xml.EndDocumentInstruction;
import org.teiid.query.processor.xml.ExecSqlInstruction;
import org.teiid.query.processor.xml.ExecStagingTableInstruction;
import org.teiid.query.processor.xml.IfInstruction;
import org.teiid.query.processor.xml.InitializeDocumentInstruction;
import org.teiid.query.processor.xml.MoveCursorInstruction;
import org.teiid.query.processor.xml.MoveDocInstruction;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.RecurseProgramCondition;
import org.teiid.query.processor.xml.WhileInstruction;

public class XMLPlanToProcessVisitor
implements MappingInterceptor {
    Stack<Program> programStack = new Stack();
    XMLPlannerEnvironment planEnv;
    Program originalProgram;
    Map<String, List<String>> unloadInstructions = new HashMap<String, List<String>>();

    public XMLPlanToProcessVisitor(XMLPlannerEnvironment env) {
        this.planEnv = env;
    }

    @Override
    public void start(MappingDocument doc, Map context) {
        Program currentProgram = new Program();
        this.programStack.push(currentProgram);
    }

    @Override
    public void end(MappingDocument doc, Map context) {
        this.originalProgram = this.programStack.pop();
        this.addUnloads(this.originalProgram, null);
    }

    @Override
    public void start(MappingAttribute attribute, Map context) {
        Program currentProgram = this.programStack.peek();
        ProcessorInstruction tagInst = TagBuilderVisitor.buildTag(attribute);
        if (tagInst != null) {
            currentProgram.addInstruction(tagInst);
        }
    }

    @Override
    public void end(MappingAttribute attribute, Map context) {
    }

    @Override
    public void start(MappingCommentNode comment, Map context) {
        Program currentProgram = this.programStack.peek();
        ProcessorInstruction tagInst = TagBuilderVisitor.buildTag(comment);
        if (tagInst != null) {
            currentProgram.addInstruction(tagInst);
        }
    }

    @Override
    public void end(MappingCommentNode comment, Map context) {
    }

    @Override
    public void start(MappingAllNode all, Map context) {
        this.commonStart(all, context);
    }

    @Override
    public void end(MappingAllNode all, Map context) {
        this.commonEnd(all, context);
    }

    @Override
    public void start(MappingChoiceNode choice, Map context) {
        IfInstruction ifInst = new IfInstruction();
        if (choice.throwExceptionOnDefault()) {
            Program subProgram = new Program();
            subProgram.addInstruction(new AbortProcessingInstruction());
            DefaultCondition defCondition = new DefaultCondition(subProgram);
            ifInst.setDefaultCondition(defCondition);
        }
        context.put(choice, ifInst);
        this.commonStart(choice, context);
        Program currentProgram = this.programStack.peek();
        currentProgram.addInstruction(ifInst);
    }

    @Override
    public void end(MappingChoiceNode choice, Map context) {
        this.commonEnd(choice, context);
        context.remove(choice);
    }

    @Override
    public void start(MappingCriteriaNode node, Map context) {
        Program childProgram = new Program();
        IfInstruction ifInst = (IfInstruction)context.get(node.getParentNode());
        if (node.getCriteria() != null) {
            CriteriaCondition condition = new CriteriaCondition(node.getCriteriaNode(), childProgram);
            ifInst.addCondition(condition);
        }
        if (node.isDefault()) {
            DefaultCondition defCondition = new DefaultCondition(childProgram);
            ifInst.setDefaultCondition(defCondition);
        }
        this.programStack.push(childProgram);
        this.commonStart(node, context);
    }

    @Override
    public void end(MappingCriteriaNode element, Map context) {
        this.commonEnd(element, context);
        this.programStack.pop();
    }

    @Override
    public void start(MappingSequenceNode sequence, Map context) {
        this.commonStart(sequence, context);
    }

    @Override
    public void end(MappingSequenceNode sequence, Map context) {
        this.commonEnd(sequence, context);
    }

    private void startRootRecursive(MappingBaseNode node, Map context) {
        Program childProgram = new Program();
        context.put(node.getRecursionId(), childProgram);
        this.programStack.push(childProgram);
    }

    private void endRootRecursive(MappingBaseNode node, Map context) {
        Program recursiveProgram = this.programStack.pop();
        Program currentProgram = this.programStack.peek();
        currentProgram.addInstructions(recursiveProgram);
        context.remove(node.getRecursionId());
        ProcessorInstruction firstInst = recursiveProgram.getInstructionAt(0);
        if (firstInst instanceof AddNodeInstruction) {
            recursiveProgram.removeInstructionAt(0);
        }
    }

    @Override
    public void start(MappingElement element, Map context) {
        Program currentProgram = this.programStack.peek();
        this.startFragment(currentProgram, element);
        ProcessorInstruction tagInst = TagBuilderVisitor.buildTag(element);
        currentProgram.addInstruction(tagInst);
        this.commonStart(element, context);
        if (!element.getChildren().isEmpty()) {
            currentProgram = this.programStack.peek();
            currentProgram.addInstruction(new MoveDocInstruction(1));
        }
    }

    @Override
    public void end(MappingElement element, Map context) {
        Program currentProgram = this.programStack.peek();
        if (!element.getChildren().isEmpty()) {
            currentProgram.addInstruction(new MoveDocInstruction(0));
        }
        this.commonEnd(element, context);
        currentProgram = this.programStack.peek();
        this.endFragment(currentProgram, element);
    }

    @Override
    public void start(MappingSourceNode node, Map context) {
        Program currentProgram = this.programStack.peek();
        this.commonStart(node, context);
        String source = node.getActualResultSetName();
        ResultSetInfo info = node.getResultSetInfo();
        ExecSqlInstruction sqlInst = new ExecSqlInstruction(source, info);
        currentProgram.addInstruction(sqlInst);
        BlockInstruction blockInst = new BlockInstruction(source);
        currentProgram.addInstruction(blockInst);
        MoveCursorInstruction moveCursor = new MoveCursorInstruction(source);
        currentProgram.addInstruction(moveCursor);
        WhileInstruction whileInst = new WhileInstruction(source);
        currentProgram.addInstruction(whileInst);
        Program childProgram = new Program();
        whileInst.setBlockProgram(childProgram);
        EndBlockInstruction closeInst = new EndBlockInstruction(source);
        currentProgram.addInstruction(closeInst);
        this.programStack.push(childProgram);
    }

    @Override
    public void end(MappingSourceNode node, Map context) {
        Program currentProgram = this.programStack.peek();
        String source = node.getActualResultSetName();
        currentProgram.addInstruction(new MoveCursorInstruction(source));
        this.programStack.pop();
        this.commonEnd(node, context);
    }

    private void startFragment(Program program, MappingBaseNode element) {
        if (element.isTagRoot()) {
            MappingDocument doc = element.getDocument();
            InitializeDocumentInstruction header = new InitializeDocumentInstruction(doc.getDocumentEncoding(), doc.isFormatted());
            program.addInstruction(header);
        }
    }

    private void endFragment(Program program, MappingBaseNode element) {
        if (element.isTagRoot()) {
            program.addInstruction(new EndDocumentInstruction());
        }
    }

    private void commonStart(MappingBaseNode node, Map context) {
        if (node.isRootRecursiveNode()) {
            this.startRootRecursive(node, context);
        }
        List<String> stagingTables = node.getStagingTables();
        Program currentProgram = this.programStack.peek();
        for (String table : stagingTables) {
            ResultSetInfo stagingTableResultsInfo = this.planEnv.getStagingTableResultsInfo(table);
            currentProgram.addInstruction(new ExecStagingTableInstruction(table, stagingTableResultsInfo));
            String unloadName = this.planEnv.unLoadResultName(table);
            String parent = stagingTableResultsInfo.getStagingRoot();
            List<String> instructions = this.unloadInstructions.get(parent);
            if (instructions == null) {
                instructions = new LinkedList<String>();
                this.unloadInstructions.put(parent, instructions);
            }
            instructions.add(unloadName);
        }
    }

    private void commonEnd(MappingBaseNode node, Map context) {
        if (node.isRootRecursiveNode()) {
            this.endRootRecursive(node, context);
        }
        Program currentProgram = this.programStack.peek();
        if (node instanceof MappingSourceNode) {
            String name = node.getSource();
            this.addUnloads(currentProgram, name);
        }
    }

    private void addUnloads(Program currentProgram, String name) {
        List<String> unloads = this.unloadInstructions.get(name);
        if (unloads != null) {
            for (String string : unloads) {
                currentProgram.addInstruction(new ExecStagingTableInstruction(string, this.planEnv.getStagingTableResultsInfo(string)));
            }
        }
    }

    @Override
    public void start(MappingRecursiveElement element, Map context) {
        Program currentProgram = this.programStack.peek();
        this.startFragment(currentProgram, element);
        ProcessorInstruction tagInst = TagBuilderVisitor.buildTag(element);
        currentProgram.addInstruction(tagInst);
        Program recursiveProgram = (Program)context.get(element.getMappingClass());
        IfInstruction ifInst = new IfInstruction();
        RecurseProgramCondition recurseCondition = XMLPlanToProcessVisitor.buildRecurseCondition(element, recursiveProgram);
        ifInst.addCondition(recurseCondition);
        ifInst.setDefaultCondition(new DefaultCondition(new Program()));
        currentProgram.addInstruction(ifInst);
    }

    @Override
    public void end(MappingRecursiveElement element, Map context) {
        Program currentProgram = this.programStack.peek();
        this.endFragment(currentProgram, element);
    }

    private static RecurseProgramCondition buildRecurseCondition(MappingRecursiveElement element, Program subProgram) {
        String criteriaString = element.getCriteria();
        RecurseProgramCondition condition = null;
        condition = criteriaString == null || criteriaString.trim().length() == 0 ? new RecurseProgramCondition(subProgram, null, element.getRecursionLimit(), element.throwExceptionOnRecurrsionLimit()) : new RecurseProgramCondition(subProgram, element.getCriteriaNode(), element.getRecursionLimit(), element.throwExceptionOnRecurrsionLimit());
        return condition;
    }

    public static Program planProgram(MappingDocument doc, XMLPlannerEnvironment env) {
        XMLPlanToProcessVisitor visitor = new XMLPlanToProcessVisitor(env);
        doc.acceptVisitor(new InterceptingVisitor(visitor));
        return visitor.originalProgram;
    }
}

