/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.Program;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class IfInstruction
extends ProgramInstruction {
    private Program ifProgram;
    private Program elseProgram;
    private Criteria condition;

    public IfInstruction(Criteria condition, Program ifProgram, Program elseProgram) {
        this.condition = condition;
        this.ifProgram = ifProgram;
        this.elseProgram = elseProgram;
    }

    public IfInstruction(Criteria condition, Program ifProgram) {
        this(condition, ifProgram, null);
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        boolean evalValue = procEnv.evaluateCriteria(this.condition);
        if (evalValue) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"IFInstruction:  The criteria on the if block evaluated to true, processing the if block"});
            procEnv.push(this.ifProgram);
        } else if (this.elseProgram != null) {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"IFInstruction:  The criteria on the if block evaluated to false, processing the else block"});
            procEnv.push(this.elseProgram);
        }
    }

    public Program getIfProgram() {
        return this.ifProgram;
    }

    public Program getElseProgram() {
        return this.elseProgram;
    }

    @Override
    public IfInstruction clone() {
        Program cloneIf = this.ifProgram.clone();
        Program cloneElse = null;
        if (this.elseProgram != null) {
            cloneElse = this.elseProgram.clone();
        }
        IfInstruction clone = new IfInstruction(this.condition, cloneIf, cloneElse);
        return clone;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("IF INSTRUCTION: ");
        sb.append(this.condition);
        sb.append("\n").append(this.ifProgram);
        if (this.elseProgram != null) {
            sb.append("\nELSE\n");
            sb.append(this.elseProgram);
        }
        return sb.toString();
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("IF");
        props.addProperty("Criteria", this.condition.toString());
        props.addProperty("Then", this.ifProgram.getDescriptionProperties());
        if (this.elseProgram != null) {
            props.addProperty("Else", this.elseProgram.getDescriptionProperties());
        }
        return props;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        Boolean conditionRequires = SubqueryAwareRelationalNode.requiresTransaction(transactionalReads, ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(this.condition));
        if (conditionRequires != null && conditionRequires.booleanValue()) {
            return true;
        }
        Boolean requires = this.ifProgram.requiresTransaction(transactionalReads);
        if (requires != null && requires.booleanValue()) {
            return true;
        }
        if (this.elseProgram != null) {
            Boolean requiresElse = this.elseProgram.requiresTransaction(transactionalReads);
            if (requiresElse != null && requiresElse.booleanValue()) {
                return true;
            }
            if (requiresElse == null) {
                return conditionRequires == null ? Boolean.valueOf(true) : null;
            }
        }
        if (requires == null) {
            return conditionRequires == null ? Boolean.valueOf(true) : null;
        }
        return conditionRequires;
    }
}

