/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.RelationalNode;

public class DupRemoveNode
extends RelationalNode {
    private STree stree = null;
    private TupleBatch batch;
    private int counter;

    public DupRemoveNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.stree = null;
        this.counter = 0;
        this.batch = null;
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        super.open();
        this.stree = this.getBufferManager().createSTree(this.getElements(), this.getConnectionID(), this.getElements().size());
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        while (true) {
            if (this.batch == null) {
                this.batch = this.getChildren()[0].nextBatch();
            }
            List<List<?>> tuples = this.batch.getTuples();
            while (this.counter < tuples.size()) {
                List<?> tuple = tuples.get(this.counter);
                List existing = this.stree.insert(tuple, STree.InsertMode.NEW, -1);
                if (existing == null) {
                    this.addBatchRow(tuple);
                    if (this.isBatchFull()) {
                        return this.pullBatch();
                    }
                }
                ++this.counter;
            }
            if (this.batch.getTerminationFlag()) {
                this.terminateBatches();
                return this.pullBatch();
            }
            this.batch = null;
            this.counter = 0;
        }
    }

    @Override
    public void closeDirect() {
        if (this.stree != null) {
            this.stree.remove();
        }
    }

    @Override
    public Object clone() {
        DupRemoveNode clonedNode = new DupRemoveNode(super.getID());
        this.copyTo(clonedNode);
        return clonedNode;
    }
}

