/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.GYearMonthValue;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.util.CommandContext;

public final class XMLValueTranslator {
    private static String NEGATIVE_INFINITY = "-INF";
    private static String POSITIVE_INFINITY = "INF";
    private static String GMONTHDAY_FORMAT = "--MM-dd";
    private static String GYEAR_FORMAT = "0000";
    public static final String DATETIME = "dateTime";
    public static final String DOUBLE = "double";
    public static final String FLOAT = "float";
    public static final String GDAY = "gDay";
    public static final String GMONTH = "gMonth";
    public static final String GMONTHDAY = "gMonthDay";
    public static final String GYEAR = "gYear";
    public static final String GYEARMONTH = "gYearMonth";
    public static final String STRING = "string";
    private static final Map<String, Integer> TYPE_CODE_MAP = new HashMap<String, Integer>(20);
    private static final int DATETIME_CODE = 0;
    private static final int DOUBLE_CODE = 1;
    private static final int FLOAT_CODE = 2;
    private static final int GDAY_CODE = 3;
    private static final int GMONTH_CODE = 4;
    private static final int GMONTHDAY_CODE = 5;
    private static final int GYEAR_CODE = 6;
    private static final int GYEARMONTH_CODE = 7;

    public static String translateToXMLValue(Object value, Class<?> runtimeType, String builtInType, CommandContext context) throws FunctionExecutionException, TransformationException {
        if (value == null) {
            return null;
        }
        Integer typeCode = TYPE_CODE_MAP.get(builtInType);
        String valueStr = null;
        if (builtInType == null || typeCode == null || runtimeType == DataTypeManager.DefaultDataClasses.STRING || STRING.equals(builtInType)) {
            valueStr = XMLValueTranslator.defaultTranslation(value);
        } else {
            int type = typeCode;
            switch (type) {
                case 0: {
                    try {
                        valueStr = XMLSystemFunctions.convertToAtomicValue(value).getStringValue();
                        break;
                    }
                    catch (TransformerException e) {
                        throw new TransformationException((BundleUtil.Event)QueryPlugin.Event.TEIID30208, (Throwable)e, e.getMessage());
                    }
                }
                case 1: {
                    valueStr = XMLValueTranslator.doubleToDouble((Double)value);
                    break;
                }
                case 2: {
                    valueStr = XMLValueTranslator.floatToFloat((Float)value);
                    break;
                }
                case 3: {
                    valueStr = XMLValueTranslator.bigIntegerTogDay((BigInteger)value);
                    break;
                }
                case 4: {
                    valueStr = XMLValueTranslator.bigIntegerTogMonth((BigInteger)value);
                    break;
                }
                case 5: {
                    valueStr = FunctionMethods.format(context, (Timestamp)value, GMONTHDAY_FORMAT);
                    break;
                }
                case 6: {
                    valueStr = FunctionMethods.format(context, (BigInteger)value, GYEAR_FORMAT);
                    break;
                }
                case 7: {
                    DateTimeValue dtv;
                    try {
                        dtv = (DateTimeValue)XMLSystemFunctions.convertToAtomicValue(value);
                    }
                    catch (TransformerException e) {
                        throw new TransformationException((BundleUtil.Event)QueryPlugin.Event.TEIID30209, (Throwable)e, e.getMessage());
                    }
                    valueStr = new GYearMonthValue(dtv.getYear(), dtv.getMonth(), dtv.getTimezoneInMinutes(), true).getStringValue();
                    break;
                }
                default: {
                    valueStr = XMLValueTranslator.defaultTranslation(value);
                }
            }
        }
        if (valueStr != null && valueStr.length() == 0) {
            valueStr = null;
        }
        return valueStr;
    }

    static String defaultTranslation(Object value) throws TransformationException {
        return (String)DataTypeManager.transformValue((Object)value, (Class)DataTypeManager.DefaultDataClasses.STRING);
    }

    static String floatToFloat(Float f) throws TransformationException {
        if (f.floatValue() == Float.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (f.floatValue() == Float.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        return XMLValueTranslator.defaultTranslation(f);
    }

    static String doubleToDouble(Double d) throws TransformationException {
        if (d == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY;
        }
        return XMLValueTranslator.defaultTranslation(d);
    }

    static String bigIntegerTogMonth(BigInteger value) {
        long month = value.longValue();
        if (month < 10L) {
            return "--0" + month;
        }
        return "--" + month;
    }

    static String bigIntegerTogDay(BigInteger value) {
        long day = value.longValue();
        if (day < 10L) {
            return "---0" + day;
        }
        return "---" + day;
    }

    static {
        TYPE_CODE_MAP.put(DATETIME, new Integer(0));
        TYPE_CODE_MAP.put(DOUBLE, new Integer(1));
        TYPE_CODE_MAP.put(FLOAT, new Integer(2));
        TYPE_CODE_MAP.put(GDAY, new Integer(3));
        TYPE_CODE_MAP.put(GMONTH, new Integer(4));
        TYPE_CODE_MAP.put(GMONTHDAY, new Integer(5));
        TYPE_CODE_MAP.put(GYEAR, new Integer(6));
        TYPE_CODE_MAP.put(GYEARMONTH, new Integer(7));
    }
}

