/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;

public abstract class TableFunctionReference
extends FromClause {
    private GroupSymbol symbol;
    private SymbolMap correlatedReferences;

    public SymbolMap getCorrelatedReferences() {
        return this.correlatedReferences;
    }

    public void setCorrelatedReferences(SymbolMap correlatedReferences) {
        this.correlatedReferences = correlatedReferences;
    }

    public void copy(TableFunctionReference copy) {
        copy.symbol = this.symbol.clone();
        if (this.correlatedReferences != null) {
            copy.correlatedReferences = this.correlatedReferences.clone();
        }
    }

    @Override
    public void collectGroups(Collection<GroupSymbol> groups) {
        groups.add(this.getGroupSymbol());
    }

    public String getName() {
        return this.symbol.getName();
    }

    public String getOutputName() {
        return this.symbol.getOutputName();
    }

    public GroupSymbol getGroupSymbol() {
        return this.symbol;
    }

    public void setName(String name) {
        this.symbol = new GroupSymbol(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TableFunctionReference)) {
            return false;
        }
        TableFunctionReference other = (TableFunctionReference)obj;
        return EquivalenceUtil.areEqual((Object)this.symbol, (Object)other.symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public abstract List<? extends ProjectedColumn> getColumns();

    public List<ElementSymbol> getProjectedSymbols() {
        ArrayList<ElementSymbol> symbols = new ArrayList<ElementSymbol>(this.getColumns().size());
        for (ProjectedColumn projectedColumn : this.getColumns()) {
            symbols.add(projectedColumn.getSymbol());
        }
        return symbols;
    }

    public static class ProjectedColumn {
        private String name;
        private String type;
        private ElementSymbol symbol;

        public ProjectedColumn(String name, String type) {
            this.name = name;
            this.type = type;
            this.symbol = new ElementSymbol(name);
            this.symbol.setType(DataTypeManager.getDataTypeClass((String)type));
        }

        protected ProjectedColumn() {
        }

        public ElementSymbol getSymbol() {
            return this.symbol;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProjectedColumn)) {
                return false;
            }
            ProjectedColumn other = (ProjectedColumn)obj;
            return this.symbol.equals(other.symbol) && this.name.equals(other.name) && this.type.equals(other.type);
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        public ProjectedColumn copyTo(ProjectedColumn copy) {
            copy.name = this.name;
            copy.type = this.type;
            copy.symbol = this.symbol.clone();
            return copy;
        }
    }
}

