/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.Statement;

public class IfStatement
extends Statement {
    private Block ifBlock;
    private Block elseBlock;
    private Criteria condition;

    public IfStatement() {
    }

    public IfStatement(Criteria criteria, Block ifBlock, Block elseBlock) {
        this.ifBlock = ifBlock;
        this.elseBlock = elseBlock;
        this.condition = criteria;
    }

    public IfStatement(Criteria criteria, Block ifBlock) {
        this(criteria, ifBlock, null);
    }

    public Block getIfBlock() {
        return this.ifBlock;
    }

    public void setIfBlock(Block block) {
        this.ifBlock = block;
    }

    public Block getElseBlock() {
        return this.elseBlock;
    }

    public void setElseBlock(Block block) {
        this.elseBlock = block;
    }

    public boolean hasElseBlock() {
        return this.elseBlock != null;
    }

    public Criteria getCondition() {
        return this.condition;
    }

    public void setCondition(Criteria criteria) {
        this.condition = criteria;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        Block otherIf = this.ifBlock.clone();
        Criteria otherCrit = (Criteria)this.condition.clone();
        Block otherElse = null;
        if (this.hasElseBlock()) {
            otherElse = this.elseBlock.clone();
        }
        return new IfStatement(otherCrit, otherIf, otherElse);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IfStatement)) {
            return false;
        }
        IfStatement other = (IfStatement)obj;
        return EquivalenceUtil.areEqual((Object)this.getCondition(), (Object)other.getCondition()) && EquivalenceUtil.areEqual((Object)this.getIfBlock(), (Object)other.getIfBlock()) && EquivalenceUtil.areEqual((Object)this.getElseBlock(), (Object)other.getElseBlock());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getCondition()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getIfBlock()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getElseBlock()});
        return myHash;
    }
}

