/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.GroupSymbol;

public class GroupCollectorVisitor
extends LanguageVisitor {
    private Collection<GroupSymbol> groups;
    private boolean isIntoClauseGroup;
    private boolean ignoreInlineViewGroups = false;
    private Collection<GroupSymbol> inlineViewGroups;

    public GroupCollectorVisitor(Collection<GroupSymbol> groups) {
        if (groups == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0023"));
        }
        this.groups = groups;
    }

    public Collection<GroupSymbol> getGroups() {
        return this.groups;
    }

    public Collection<GroupSymbol> getInlineViewGroups() {
        return this.inlineViewGroups;
    }

    public void setIgnoreInlineViewGroups(boolean ignoreInlineViewGroups) {
        this.ignoreInlineViewGroups = ignoreInlineViewGroups;
    }

    @Override
    public void visit(GroupSymbol obj) {
        if (this.isIntoClauseGroup) {
            if (!obj.isTempGroupSymbol()) {
                this.groups.add(obj);
            }
            this.isIntoClauseGroup = false;
        } else {
            this.groups.add(obj);
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.groups.add(obj.getGroup());
    }

    @Override
    public void visit(Into obj) {
        this.isIntoClauseGroup = true;
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        if (this.ignoreInlineViewGroups) {
            if (this.inlineViewGroups == null) {
                this.inlineViewGroups = new ArrayList<GroupSymbol>();
            }
            this.inlineViewGroups.add(obj.getGroupSymbol());
        }
    }

    public static void getGroups(LanguageObject obj, Collection<GroupSymbol> groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        PreOrderNavigator.doVisit(obj, visitor);
    }

    public static Collection<GroupSymbol> getGroups(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        PreOrderNavigator.doVisit(obj, visitor);
        return groups;
    }

    public static void getGroupsIgnoreInlineViewsAndEvaluatableSubqueries(LanguageObject obj, Collection<GroupSymbol> groups) {
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        visitor.setIgnoreInlineViewGroups(true);
        PreOrPostOrderNavigator nav = new PreOrPostOrderNavigator(visitor, true, true);
        nav.setSkipEvaluatable(true);
        obj.acceptVisitor(nav);
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
    }

    public static Collection<GroupSymbol> getGroupsIgnoreInlineViews(LanguageObject obj, boolean removeDuplicates) {
        AbstractCollection groups = null;
        groups = removeDuplicates ? new LinkedHashSet() : new ArrayList();
        GroupCollectorVisitor visitor = new GroupCollectorVisitor(groups);
        visitor.setIgnoreInlineViewGroups(true);
        DeepPreOrderNavigator.doVisit(obj, visitor);
        if (visitor.getInlineViewGroups() != null) {
            groups.removeAll(visitor.getInlineViewGroups());
        }
        return groups;
    }
}

