/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata.index;

import java.io.IOException;
import java.util.ArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.index.IEntryResult;
import org.teiid.internal.core.index.Index;
import org.teiid.metadata.index.RecordFactory;
import org.teiid.metadata.index.RuntimeMetadataPlugin;

public class SimpleIndexUtil {
    public static final boolean CASE_SENSITIVE_INDEX_FILE_NAMES = false;

    public static IEntryResult[] queryIndex(Index[] indexes, char[] pattern, boolean isPrefix, boolean isCaseSensitive, boolean returnFirstMatch) throws TeiidException {
        ArrayList<IEntryResult> queryResult = new ArrayList<IEntryResult>();
        try {
            for (int i = 0; i < indexes.length; ++i) {
                IEntryResult[] partialResults = null;
                partialResults = isPrefix ? indexes[i].queryEntries(pattern, isCaseSensitive) : indexes[i].queryEntriesMatching(pattern, isCaseSensitive);
                if (partialResults != null) {
                    partialResults = SimpleIndexUtil.addContinuationRecords(indexes[i], partialResults);
                }
                if (partialResults != null) {
                    for (int j = 0; j < partialResults.length; ++j) {
                        IEntryResult result = partialResults[j];
                        if (result == null || result.getWord()[0] == '&') continue;
                        queryResult.add(partialResults[j]);
                    }
                }
                if (!returnFirstMatch || queryResult.size() <= 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new TeiidException((BundleUtil.Event)RuntimeMetadataPlugin.Event.TEIID80003, (Throwable)e);
        }
        return queryResult.toArray(new IEntryResult[queryResult.size()]);
    }

    private static IEntryResult[] addContinuationRecords(Index index, IEntryResult[] partialResults) throws IOException {
        int blockSize = 8160;
        IEntryResult[] results = partialResults;
        for (int i = 0; i < results.length; ++i) {
            IEntryResult partialResult = results[i];
            char[] word = partialResult.getWord();
            if (word.length < 8160 || word[8159] != '&') continue;
            String objectID = RecordFactory.extractUUIDString(partialResult);
            String patternStr = "&" + word[0] + '\u00a0' + objectID + '\u00a0';
            IEntryResult[] continuationResults = index.queryEntries(patternStr.toCharArray(), true);
            if (continuationResults == null || continuationResults.length <= 0) continue;
            results[i] = RecordFactory.joinEntryResults(partialResult, continuationResults, 8160);
        }
        return results;
    }
}

