/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.util;

import ch.qos.cal10n.util.CAL10NResourceBundle;
import ch.qos.cal10n.util.MiscUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;

public class CAL10NResourceBundleFinder {
    public static CAL10NResourceBundle getBundle(ClassLoader classLoader, String baseName, Locale locale, String charset) {
        baseName = baseName.replace('.', '/');
        String languageAndCountryCandidate = CAL10NResourceBundleFinder.computeLanguageAndCountryCandidate(baseName, locale);
        String languageOnlyCandidate = CAL10NResourceBundleFinder.computeLanguageOnlyCandidate(baseName, locale);
        CAL10NResourceBundle cprbLanguageOnly = CAL10NResourceBundleFinder.makePropertyResourceBundle(classLoader, languageOnlyCandidate, charset);
        CAL10NResourceBundle cprbLanguageAndCountry = null;
        if (languageAndCountryCandidate != null) {
            cprbLanguageAndCountry = CAL10NResourceBundleFinder.makePropertyResourceBundle(classLoader, languageAndCountryCandidate, charset);
        }
        if (cprbLanguageAndCountry != null) {
            cprbLanguageAndCountry.setParent(cprbLanguageOnly);
            return cprbLanguageAndCountry;
        }
        return cprbLanguageOnly;
    }

    private static CAL10NResourceBundle makePropertyResourceBundle(ClassLoader classLoader, String resourceCandiate, String charset) {
        CAL10NResourceBundle prb = null;
        URL url = classLoader.getResource(resourceCandiate);
        if (url != null) {
            try {
                InputStream in = CAL10NResourceBundleFinder.openConnectionForUrl(url);
                Reader reader = CAL10NResourceBundleFinder.toReader(in, charset);
                reader = charset == null || charset.length() == 0 ? new InputStreamReader(in) : new InputStreamReader(in, charset);
                prb = new CAL10NResourceBundle(reader, MiscUtil.urlToFile(url));
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return prb;
    }

    static Reader toReader(InputStream in, String charset) {
        if (charset == null || charset.length() == 0) {
            return new InputStreamReader(in);
        }
        try {
            return new InputStreamReader(in, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Failed to open reader", e);
        }
    }

    private static String computeLanguageAndCountryCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (country != null && country.length() > 0) {
            return baseName + "_" + language + "_" + country + ".properties";
        }
        return null;
    }

    private static String computeLanguageOnlyCandidate(String baseName, Locale locale) {
        String language = locale.getLanguage();
        return baseName + "_" + language + ".properties";
    }

    private static InputStream openConnectionForUrl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setDefaultUseCaches(false);
        InputStream in = urlConnection.getInputStream();
        return in;
    }
}

