/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.weld.manager.api.ExecutorServices;

public class SingleThreadExecutorServices
implements ExecutorServices {
    private final transient ExecutorService taskExecutor = Executors.newSingleThreadExecutor();

    @Override
    public ExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void cleanup() {
        this.taskExecutor.shutdown();
        try {
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
            this.taskExecutor.shutdownNow();
            if (this.taskExecutor.awaitTermination(60L, TimeUnit.SECONDS)) return;
        }
        catch (InterruptedException ie) {
            this.taskExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

