/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.reflection.SecureReflections;

public class ApiAbstraction {
    private static final Class<DummyAnnotation> DUMMY_ANNOTATION = DummyAnnotation.class;
    private static final Class<Dummy> DUMMY_CLASS = Dummy.class;
    private ResourceLoader resourceLoader;

    public ApiAbstraction(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    protected Class<? extends Annotation> annotationTypeForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_ANNOTATION;
        }
    }

    protected Class<?> classForName(String name) {
        try {
            return this.resourceLoader.classForName(name);
        }
        catch (ResourceLoadingException cnfe) {
            return DUMMY_CLASS;
        }
    }

    protected Object enumValue(Class<?> clazz, String memberName) {
        if (!clazz.isEnum()) {
            throw new IllegalArgumentException(UtilMessage.CLASS_NOT_ENUM, clazz);
        }
        try {
            return SecureReflections.getField(clazz, memberName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static enum DummyEnum {
        DUMMY_VALUE;

    }

    public static interface Dummy {
    }

    public static @interface DummyAnnotation {
    }
}

