/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.http.HttpConversationContextImpl;
import org.jboss.weld.logging.ConversationLogger;
import org.jboss.weld.serialization.BeanIdentifierIndex;
import org.jboss.weld.servlet.ConversationContextActivator;
import org.jboss.weld.util.Consumer;

public class LazyHttpConversationContextImpl
extends HttpConversationContextImpl {
    private final ThreadLocal<Consumer<HttpServletRequest>> initializationCallback;
    private final ThreadLocal<Object> initialized = new ThreadLocal();

    public LazyHttpConversationContextImpl(String contextId, BeanIdentifierIndex beanIdentifierIndex) {
        super(contextId, beanIdentifierIndex);
        this.initializationCallback = new ThreadLocal();
    }

    public void activate(Consumer<HttpServletRequest> initializationCallback) {
        this.activate();
        if (initializationCallback != null) {
            this.initializationCallback.set(initializationCallback);
        } else {
            this.initializationCallback.set(null);
        }
    }

    @Override
    public void activate() {
        if (!this.isAssociated()) {
            throw ConversationLogger.LOG.mustCallAssociateBeforeActivate();
        }
        if (!this.isActive()) {
            super.setActive(true);
        } else {
            ConversationLogger.LOG.contextAlreadyActive(this.getRequest());
        }
        this.initialized.set(null);
    }

    public boolean isInitialized() {
        return this.initialized.get() != null;
    }

    @Override
    protected void initialize(String cid) {
        this.initialized.set(Boolean.TRUE);
        super.initialize(cid);
    }

    @Override
    public void deactivate() {
        block7: {
            try {
                if (this.isInitialized()) {
                    try {
                        super.deactivate();
                        break block7;
                    }
                    finally {
                        this.initialized.set(null);
                    }
                }
                super.setActive(false);
            }
            finally {
                this.initializationCallback.set(null);
            }
        }
    }

    @Override
    public boolean destroy(HttpSession session) {
        if (this.isAssociated()) {
            this.checkContextInitialized();
        }
        return super.destroy(session);
    }

    @Override
    protected void checkContextInitialized() {
        if (!this.isInitialized()) {
            Consumer<HttpServletRequest> callback;
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            String cid = ConversationContextActivator.determineConversationId(request, this.getParameterName());
            this.initialize(cid);
            if (cid == null && (callback = this.initializationCallback.get()) != null) {
                callback.accept(request);
            }
        }
    }
}

