/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.beans.InstanceManager;
import org.jboss.weld.environment.se.beans.ParametersFactory;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.threading.RunnableDecorator;
import org.jboss.weld.util.annotated.ForwardingAnnotatedType;

@Vetoed
public class WeldSEBeanRegistrant
implements Extension {
    private ThreadContext threadContext;

    public void registerWeldSEBeans(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        VetoedSuppressedAnnotatedType<ParametersFactory> parametersFactory = new VetoedSuppressedAnnotatedType<ParametersFactory>(manager.createAnnotatedType(ParametersFactory.class));
        VetoedSuppressedAnnotatedType<InstanceManager> instanceManager = new VetoedSuppressedAnnotatedType<InstanceManager>(manager.createAnnotatedType(InstanceManager.class));
        VetoedSuppressedAnnotatedType<RunnableDecorator> runnableDecorator = new VetoedSuppressedAnnotatedType<RunnableDecorator>(manager.createAnnotatedType(RunnableDecorator.class));
        VetoedSuppressedAnnotatedType<WeldContainer> weldContainer = new VetoedSuppressedAnnotatedType<WeldContainer>(manager.createAnnotatedType(WeldContainer.class));
        event.addAnnotatedType(parametersFactory);
        event.addAnnotatedType(instanceManager);
        event.addAnnotatedType(runnableDecorator);
        event.addAnnotatedType(weldContainer);
    }

    public void registerWeldSEContexts(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        this.threadContext = new ThreadContext(BeanManagerProxy.unwrap(manager).getContextId());
        event.addContext(this.threadContext);
    }

    private static boolean ignoreEvent(Object event) {
        return !(event instanceof AbstractContainerEvent);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    private class VetoedSuppressedAnnotatedType<T>
    extends ForwardingAnnotatedType<T> {
        private final AnnotatedType<T> annotatedType;

        public VetoedSuppressedAnnotatedType(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            if (annotationType == Vetoed.class) {
                return null;
            }
            return this.annotatedType.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            for (Annotation a : this.annotatedType.getAnnotations()) {
                if (a.annotationType() == Vetoed.class) continue;
                annotations.add(a);
            }
            return annotations;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            if (annotationType == Vetoed.class) {
                return false;
            }
            return this.annotatedType.isAnnotationPresent(annotationType);
        }

        @Override
        public AnnotatedType<T> delegate() {
            return this.annotatedType;
        }
    }
}

