/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.logging.InterceptorLogger;

public final class InterceptionTypeRegistry {
    private static final Map<InterceptionType, Class<? extends Annotation>> INTERCEPTOR_ANNOTATION_CLASSES;

    private InterceptionTypeRegistry() {
    }

    public static Collection<InterceptionType> getSupportedInterceptionTypes() {
        return INTERCEPTOR_ANNOTATION_CLASSES.keySet();
    }

    public static boolean isSupported(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.containsKey((Object)interceptionType);
    }

    public static Class<? extends Annotation> getAnnotationClass(InterceptionType interceptionType) {
        return INTERCEPTOR_ANNOTATION_CLASSES.get((Object)interceptionType);
    }

    static {
        HashMap interceptionAnnotationClasses = new HashMap();
        for (InterceptionType interceptionType : InterceptionType.values()) {
            try {
                interceptionAnnotationClasses.put(interceptionType, InterceptionTypeRegistry.class.getClassLoader().loadClass(interceptionType.annotationClassName()));
            }
            catch (Exception e) {
                if (!InterceptionUtils.isAnnotationClassExpected(interceptionType)) continue;
                InterceptorLogger.LOG.interceptorAnnotationClassNotFound(interceptionType.annotationClassName());
            }
        }
        INTERCEPTOR_ANNOTATION_CLASSES = Collections.unmodifiableMap(interceptionAnnotationClasses);
    }
}

