/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5.auto;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Singleton;
import org.jboss.weld.injection.ForwardingInjectionTarget;

public class TestInstanceInjectionExtension<T>
implements Extension {
    private static final AnnotationLiteral<Singleton> SINGLETON_LITERAL = new AnnotationLiteral<Singleton>(){};
    private Class<?> testClass;
    private T testInstance;

    TestInstanceInjectionExtension(T testInstance) {
        this.testClass = testInstance.getClass();
        this.testInstance = testInstance;
    }

    void rewriteTestClassScope(@Observes ProcessAnnotatedType<T> pat, BeanManager beanManager) {
        if (pat.getAnnotatedType().getJavaClass().equals(this.testClass)) {
            pat.configureAnnotatedType().add(SINGLETON_LITERAL);
        }
    }

    void rewriteTestInstanceInjectionTarget(@Observes ProcessInjectionTarget<T> pit) {
        if (pit.getAnnotatedType().getJavaClass().equals(this.testClass)) {
            pit.setInjectionTarget((InjectionTarget)new TestInstanceInjectionTarget(pit.getInjectionTarget()));
        }
    }

    private class TestInstanceInjectionTarget
    extends ForwardingInjectionTarget<T> {
        private InjectionTarget<T> injectionTarget;

        TestInstanceInjectionTarget(InjectionTarget<T> injectionTarget) {
            this.injectionTarget = injectionTarget;
        }

        protected InjectionTarget<T> delegate() {
            return this.injectionTarget;
        }

        public T produce(CreationalContext<T> creationalContext) {
            return TestInstanceInjectionExtension.this.testInstance;
        }
    }
}

