/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Provider;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeSafeBeanResolver<T extends Bean<?>>
extends TypeSafeResolver<Resolvable, T> {
    private final BeanManagerImpl beanManager;
    private final ConcurrentMap<Set<Bean<?>>, Set<Bean<?>>> disambiguatedBeans;
    private final LazyValueHolder<Map<Type, ArrayList<T>>> beansByType;

    public TypeSafeBeanResolver(BeanManagerImpl beanManager, final Iterable<T> beans) {
        super(beans);
        this.beanManager = beanManager;
        this.disambiguatedBeans = new MapMaker().makeComputingMap(new BeanDisambiguation());
        this.beansByType = new LazyValueHolder<Map<Type, ArrayList<T>>>(){

            @Override
            protected Map<Type, ArrayList<T>> computeValue() {
                HashMap val = new HashMap();
                for (Bean bean : beans) {
                    for (Type type : bean.getTypes()) {
                        Class clazz;
                        if (!val.containsKey(type)) {
                            val.put(type, new ArrayList());
                        }
                        ((ArrayList)val.get(type)).add(bean);
                        if (type instanceof ParameterizedType) {
                            Type rawType = ((ParameterizedType)type).getRawType();
                            if (!val.containsKey(rawType)) {
                                val.put(rawType, new ArrayList());
                            }
                            ((ArrayList)val.get(rawType)).add(bean);
                            continue;
                        }
                        if (!(type instanceof Class) || !(clazz = (Class)type).isPrimitive()) continue;
                        if (!val.containsKey(clazz = Primitives.wrap(clazz))) {
                            val.put(clazz, new ArrayList());
                        }
                        ((ArrayList)val.get(clazz)).add(bean);
                    }
                }
                for (Map.Entry entry : val.entrySet()) {
                    ((ArrayList)entry.getValue()).trimToSize();
                }
                return Collections.unmodifiableMap(val);
            }
        };
    }

    @Override
    protected boolean matches(Resolvable resolvable, T bean) {
        return Reflections.matches(resolvable.getTypes(), bean.getTypes()) && Beans.containsAllQualifiers(resolvable.getQualifiers(), bean.getQualifiers(), this.beanManager);
    }

    @Override
    protected Iterable<? extends T> getAllBeans(Resolvable resolvable) {
        if (resolvable.getTypes().contains(Object.class) || Instance.class.equals(resolvable.getJavaClass()) || Event.class.equals(resolvable.getJavaClass()) || Provider.class.equals(resolvable.getJavaClass()) || resolvable.getTypes().contains(Serializable.class)) {
            return super.getAllBeans(resolvable);
        }
        HashSet beans = new HashSet();
        for (Type type : resolvable.getTypes()) {
            Class clazz;
            List beansForType = this.beansByType.get().get(type);
            if (beansForType != null) {
                beans.addAll(beansForType);
            }
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                beansForType = this.beansByType.get().get(rawType);
                if (beansForType == null) continue;
                beans.addAll(beansForType);
                continue;
            }
            if (!(type instanceof Class) || !(clazz = (Class)type).isPrimitive()) continue;
            clazz = Primitives.wrap(clazz);
            beansForType = this.beansByType.get().get(clazz);
            if (beansForType == null) continue;
            beans.addAll(beansForType);
        }
        return beans;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    @Override
    protected Set<T> filterResult(Set<T> matched) {
        return Beans.removeDisabledAndSpecializedBeans(matched, this.beanManager);
    }

    @Override
    protected Set<T> sortResult(Set<T> matched) {
        return matched;
    }

    public <X> Set<Bean<? extends X>> resolve(Set<Bean<? extends X>> beans) {
        if (beans.size() <= 1) {
            return beans;
        }
        beans = ImmutableSet.copyOf(beans);
        return (Set)Reflections.cast(this.disambiguatedBeans.get(beans));
    }

    @Override
    public void clear() {
        super.clear();
        this.disambiguatedBeans.clear();
        this.beansByType.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanDisambiguation
    implements Function<Set<Bean<?>>, Set<Bean<?>>> {
        private BeanDisambiguation() {
        }

        @Override
        public Set<Bean<?>> apply(Set<Bean<?>> from) {
            if (from.size() > 1) {
                HashSet allBeans = new HashSet();
                HashSet alternativeBeans = new HashSet();
                for (Bean<?> bean : from) {
                    if (bean.isAlternative()) {
                        alternativeBeans.add(bean);
                    }
                    allBeans.add(bean);
                }
                if (alternativeBeans.isEmpty()) {
                    return ImmutableSet.copyOf(allBeans);
                }
                return ImmutableSet.copyOf(alternativeBeans);
            }
            return ImmutableSet.copyOf(from);
        }
    }
}

