/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.spi.AnnotationDiscovery;

public class SimpleAnnotationDiscovery
implements AnnotationDiscovery {
    private final ReflectionCache cache;

    public SimpleAnnotationDiscovery(ReflectionCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if ((clazz == javaClass || requiredAnnotation.isAnnotationPresent(Inherited.class)) && this.containsAnnotations(this.cache.getAnnotations(clazz), requiredAnnotation)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.containsAnnotations(this.cache.getAnnotations(field), requiredAnnotation)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotation)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotation)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsAnnotations(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation) {
        return this.containsAnnotation(annotations, requiredAnnotation, true);
    }

    private boolean containsAnnotation(Annotation[] annotations, Class<? extends Annotation> requiredAnnotation, boolean checkMetaAnnotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (requiredAnnotation.equals(annotationType)) {
                return true;
            }
            if (!checkMetaAnnotations || !this.containsAnnotation(this.cache.getAnnotations(annotationType), requiredAnnotation, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cleanup() {
    }
}

