/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.ProducerFactory;
import org.jboss.weld.annotated.AnnotatedTypeValidator;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.logging.messages.BeanManagerMessage;
import org.jboss.weld.manager.BeanManagerImpl;

public abstract class AbstractProducerFactory<X>
implements ProducerFactory<X> {
    private final Bean<X> declaringBean;
    private final BeanManagerImpl manager;

    protected AbstractProducerFactory(Bean<X> declaringBean, BeanManagerImpl manager) {
        this.declaringBean = declaringBean;
        this.manager = manager;
    }

    protected Bean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    protected BeanManagerImpl getManager() {
        return this.manager;
    }

    protected abstract AnnotatedMember<X> getAnnotatedMember();

    public abstract <T> Producer<T> createProducer(Bean<X> var1, Bean<T> var2, DisposalMethod<X, T> var3);

    @Override
    public <T> Producer<T> createProducer(Bean<T> bean) {
        if (this.getDeclaringBean() == null && !this.getAnnotatedMember().isStatic()) {
            throw new IllegalArgumentException(BeanManagerMessage.NULL_DECLARING_BEAN, this.getAnnotatedMember());
        }
        AnnotatedTypeValidator.validateAnnotatedMember(this.getAnnotatedMember());
        try {
            Producer<T> producer = this.createProducer(this.getDeclaringBean(), bean, null);
            this.getManager().getServices().get(InjectionTargetService.class).validateProducer(producer);
            return producer;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }
}

