/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.events.NotificationListener;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.logging.EventLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.Reflections;

public class ExtensionObserverMethodImpl<T, X>
extends ObserverMethodImpl<T, X> {
    private final Container containerLifecycleEventDeliveryLock;
    private final Set<Class<? extends Annotation>> requiredTypeAnnotations;
    private volatile Set<Class<? extends Annotation>> requiredScopeTypeAnnotations;

    protected ExtensionObserverMethodImpl(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        super(observer, declaringBean, manager);
        this.containerLifecycleEventDeliveryLock = Container.instance(manager);
        this.requiredTypeAnnotations = this.initRequiredTypeAnnotations(observer);
    }

    protected Set<Class<? extends Annotation>> initRequiredTypeAnnotations(EnhancedAnnotatedMethod<T, ? super X> observer) {
        EnhancedAnnotatedParameter<?, ? super X> eventParameter = observer.getEnhancedParameters(Observes.class).get(0);
        WithAnnotations annotation = (WithAnnotations)eventParameter.getAnnotation(WithAnnotations.class);
        if (annotation != null) {
            return ImmutableSet.copyOf((Object[])annotation.value());
        }
        return Collections.emptySet();
    }

    @Override
    protected void checkRequiredTypeAnnotations(EnhancedAnnotatedParameter<?, ?> eventParameter) {
        Type[] typeArguments;
        boolean isProcessAnnotatedType;
        Class rawObserverType = Reflections.getRawType(this.getObservedType());
        boolean bl = isProcessAnnotatedType = rawObserverType.equals(ProcessAnnotatedType.class) || rawObserverType.equals(ProcessSyntheticAnnotatedType.class);
        if (!isProcessAnnotatedType && !this.requiredTypeAnnotations.isEmpty()) {
            throw EventLogger.LOG.invalidWithAnnotations(this);
        }
        if (isProcessAnnotatedType && this.requiredTypeAnnotations.isEmpty() && ((typeArguments = eventParameter.getActualTypeArguments()).length == 0 || Reflections.isUnboundedWildcard(typeArguments[0]) || Reflections.isUnboundedTypeVariable(typeArguments[0]))) {
            EventLogger.LOG.unrestrictedProcessAnnotatedTypes(this);
        }
    }

    @Override
    protected MethodInjectionPoint<T, ? super X> initMethodInjectionPoint(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        return InjectionPointFactory.silentInstance().createMethodInjectionPoint(observer, declaringBean, declaringBean.getBeanClass(), true, manager);
    }

    @Override
    protected void preNotify(T event, Object receiver) {
        if (event instanceof NotificationListener) {
            ((NotificationListener)NotificationListener.class.cast(event)).preNotify((Extension)receiver);
        }
    }

    @Override
    protected void postNotify(T event, Object receiver) {
        if (event instanceof NotificationListener) {
            ((NotificationListener)NotificationListener.class.cast(event)).postNotify((Extension)receiver);
        }
    }

    @Override
    protected Object getReceiver(CreationalContext<X> ctx) {
        return this.getDeclaringBean().create(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendEvent(T event, Object receiver, CreationalContext<?> creationalContext) {
        Container container = this.containerLifecycleEventDeliveryLock;
        synchronized (container) {
            super.sendEvent(event, receiver, creationalContext);
        }
    }

    public Collection<Class<? extends Annotation>> getRequiredAnnotations() {
        return this.requiredTypeAnnotations;
    }

    public Collection<Class<? extends Annotation>> getRequiredScopeAnnotations() {
        if (this.requiredScopeTypeAnnotations == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Class<? extends Annotation> annotation : this.requiredTypeAnnotations) {
                if (!this.beanManager.isScope(annotation)) continue;
                builder.add(annotation);
            }
            this.requiredScopeTypeAnnotations = builder.build();
        }
        return this.requiredScopeTypeAnnotations;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionObserverMethodImpl that = (ExtensionObserverMethodImpl)obj;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

