/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableTinySet;

class ImmutableMapEntry<K, V>
extends ImmutableMap<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final K key;
    private final V value;
    private volatile transient Set<Map.Entry<K, V>> entrySet;
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;

    ImmutableMapEntry(Map.Entry<K, V> entry) {
        this(entry.getKey(), entry.getValue());
    }

    ImmutableMapEntry(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        this.key = key;
        this.value = value;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ImmutableTinySet.Singleton<ImmutableMapEntry>(this);
        }
        return this.entrySet;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ImmutableTinySet.Singleton<K>(this.key);
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ImmutableTinySet.Singleton<V>(this.value);
        }
        return this.values;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.size() != 1) {
                return false;
            }
            return this.value.equals(map.get(this.key));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode() ^ this.value.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)(this.key == this ? "(this Map)" : this.key));
        sb.append('=');
        sb.append((Object)(this.value == this ? "(this Map)" : this.value));
        sb.append('}');
        return sb.toString();
    }
}

